% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.t.q.fun.r
\name{GEN_T_q_fun}
\alias{GEN_T_q_fun}
\title{Gives values for GPAS BSWF (Timijan's formulation) as a function of
wavelength}
\usage{
GEN_T_q_fun(w.length)
}
\arguments{
\item{w.length}{numeric array of w.length (nm)}
}
\value{
a numeric array of the same length as \code{w.length} with values for
  the BSWF normalized as in the original source.  The returned values are
  based on quantum effectiveness units.
}
\description{
This function gives a set of numeric multipliers that can be used as a weight
to calculate effective doses and irradiances.
}
\note{
For wavelengths shorter than 256 nm the value returned by the equation
  starts decreasing, but we instead extrapolate this maximum value, obtained
  at 256 nm, to shorter wavelengths. For wavelengths longer than 345 nm we
  return zero, as is usual parctice.
}
\examples{
GEN_T_q_fun(293:400)

}
\seealso{
Other BSWF functions: \code{\link{CH4_e_fun}},
  \code{\link{CH4_q_fun}}, \code{\link{CIE_e_fun}},
  \code{\link{CIE_q_fun}}, \code{\link{DNA_GM_q_fun}},
  \code{\link{DNA_P_q_fun}}, \code{\link{FLAV_q_fun}},
  \code{\link{GEN_G_q_fun}}, \code{\link{GEN_M_q_fun}},
  \code{\link{ICNIRP_e_fun}}, \code{\link{PG_q_fun}}
}

