% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.n.r
\name{DNA_N}
\alias{DNA_N}
\title{Constructor of DNA damage (SETLOW) weighted waveband}
\usage{
DNA_N(norm = 300, w.low = 275, w.high = 400)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting function
and normalization wavelength.
}
\description{
Naked DNA damage BSWF
}
\examples{
DNA_N()
DNA_N(300)

}
\seealso{
\code{\link{new_waveband}}  \code{\link{waveband}}

Other BSWF weighted wavebands: 
\code{\link{CH4}()},
\code{\link{DNA_GM}()},
\code{\link{DNA_P}()},
\code{\link{FLAV}()},
\code{\link{GEN_G}()},
\code{\link{GEN_M}()},
\code{\link{GEN_T}()},
\code{\link{PAR}()},
\code{\link{PG}()},
\code{\link{UV_health_hazard}()},
\code{\link{erythema}()}
}
\concept{BSWF weighted wavebands}
