\name{phyclust-package}
\alias{phyclust-package}
\docType{package}
\title{Phyloclustering -- Phylogenetic Clustering}
\description{
  This package \pkg{phyclust} (Chen 2011) implements an novel approach
  combining model-based clusterings
  and phylogenetics to classify DNA sequences and SNP sequences.
  Based on evolution models, sequences are assumed to follow a mutation
  process/distribution clouding around an unknown center ancestor.
  Based on Continuous Time Markov Chain Theory, mixture distributions are
  established to model/classify subpopulations or population structures.

  The kernel part of the package are implemented in C.
  EM algorithms are performed to find the maximum likelihood estimators.
  Initialization methods for EM algorithms are also established.
  Several evolution models are also developed.

  \code{ms} (Hudson 2002) and \code{seq-gen} (Rambaut and Grassly 1997)
  are two useful programs to generate coalescent trees and sequences, and
  both are merged into \pkg{phyclust}. \code{baseml} of PAML (Yang 1997, 2007)
  is also ported into \pkg{phyclust} and it is a program to find a phylogenetic
  tree by maximizing likelihood. Hap-Clustering method (Tzeng 2005) for
  haplotype grouping is also incorporated into \pkg{phyclust}.

  Type \code{help(package = phyclust)} to see a list of major
  functions for which further documentations are available. The on-line
  detail instructions are also available and the link is given below in the
  \sQuote{References} section.

  Some C and R functions and R classes of the \pkg{ape} package are also
  required and modified in \pkg{phyclust}.
}
\details{
\tabular{ll}{
  Package: \tab phyclust\cr
  Type: \tab Package\cr
%  Version: \tab 0.1-2\cr
%  Date: \tab 2010-02-18\cr
  License: \tab GPL\cr
  LazyLoad: \tab yes\cr
}
  The main function is \code{phyclust} controlled by an object
  \code{.EMC} generated by a function \code{.EMControl},
  and \code{find.best} can find the best solution by repeating
  \code{phyclust} with different initializations.

  \code{ms} and \code{seqgen} can generate trees and sequences
  based on varied conditions, and they can jointly perform simulations.

  \code{paml.baseml} can estimate trees based on sequences.

  \code{haplo.post.prob} is a modified version of Tzeng's method
  for haplotype grouping which uses a evolution approach to group SNP
  sequences.

  Some tool functions of the \pkg{ape} package are utilized in this package
  to perform trees in plots, check object types, and read sequence data.
}
\references{
  Phylogenetic Clustering Website:
  \url{https://snoweye.github.io/phyclust/}

  Chen, W.-C. (2011)
  \dQuote{Overlapping codon model, phylogenetic clustering, and alternative
          partial expectation conditional maximization algorithm},
  \emph{Ph.D. Diss., Iowa Stat University}.

  Hudson, R.R. (2002)
  \dQuote{Generating Samples under a Wright-Fisher Neutral Model of Genetic
          Variation},
  \emph{Bioinformatics}, \bold{18}, 337-338.
  \url{http://home.uchicago.edu/~rhudson1/source.html}

  Rambaut, A. and Grassly, N.C. (1997)
  \dQuote{Seq-Gen: An Application for the Monte Carlo Simulation of DNA
          Sequence Evolution along Phylogenetic Trees},
  \emph{Computer Applications In The Biosciences}, \bold{13:3}, 235-238.
  \url{http://tree.bio.ed.ac.uk/software/seqgen/}

  Yang, Z. (1997)
  \dQuote{PAML: a program package for phylogenetic analysis by maximum
          likelihood},
  \emph{Computer Applications in BioSciences}, \bold{13}, 555-556.
  \url{http://abacus.gene.ucl.ac.uk/software/paml.html}

  Yang, Z. (2007)
  \dQuote{PAML 4: a program package for phylogenetic analysis by maximum
          likelihood},
  \emph{Molecular Biology and Evolution}, \bold{24}, 1586-1591.

  Tzeng, J.Y. (2005)
  \dQuote{Evolutionary-Based Grouping of Haplotypes in Association Analysis},
  \emph{Genetics Epidemiology}, \bold{28}, 220-231.
  \url{http://www4.stat.ncsu.edu/~jytzeng/software.php}

  Paradis E., Claude J., and Strimmer K. (2004)
  \dQuote{APE: analyses of phylogenetics and evolution in R language},
  \emph{Bioinformatics}, \bold{20}, 289-290.
  \url{http://ape-package.ird.fr/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com}
}
\seealso{
  \code{\link{phyclust}},
  \code{\link{.EMC}},
  \code{\link{.EMControl}},
  \code{\link{find.best}}.
}
\examples{
\dontrun{
library(phyclust, quiet = TRUE)

demo(package = "phyclust")
demo("ex_trees", package = "phyclust")
}
}
\keyword{package}
