% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widths.R
\name{widths}
\alias{widths}
\title{Number of nodes at each depth}
\usage{
widths(tree)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}
}
\value{
A vector of widths, where entry i is the number of nodes at depth i. There is a single node at depth 0 (the root) which is not included in the vector, for simplicity.
}
\description{
Find the number of nodes at each depth in the tree
}
\examples{
## Find the node widths in a random tree with 10 tips:
tree <- rtree(10)
tree$edge.length <- rep(1,18) # to make it easier to see the width and depths in the plot
plot(tree)
widths(tree)

}
\author{
Caroline Colijn \email{c.colijn@imperial.ac.uk}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

