% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopairs-package.R
\docType{package}
\name{phylopairs-package}
\alias{phylopairs-package}
\alias{phylopairs}
\title{The 'phylopairs' package.}
\description{
\code{phylopairs} provides tools for conducting comparative analyses of lineage-pair traits in a phylogenetically informed context. Comparative analyses of pairwise-defined traits like "strength of RI" or "diet niche overlap" collected for numerous pairs of related taxa can yield important insights to biologists, but it is important to recognize that such data are not independent. \code{phylopairs} provides a function, \code{taxapair.vcv()}, that calculates the expected covariance structure of a pairwise-defined trait given (1) a table of pairs, (2) a phylogeny, and (3) a chosen model (as described in Anderson et al. \emph{in review}). This covariance structure can be used in any number of downstream analyses. \code{phylopairs} provides tools for a few such analyses, including linear regression, linear mixed models, generalized least squares, and two forms of beta regression for use with bounded response variables. All analyses are conducted in a Bayesian framework using built-in \code{Stan} software programs interfaced through the \code{rstan} package.
}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{	Stan Development Team (NA). RStan: the R interface to Stan. R package version 
 2.32.6. https://mc-stan.org

	Anderson et al. *in review*. The comparative analysis of lineage-pair data. 
}\if{html}{\out{</div>}}
}
\author{
\strong{Maintainer}: Sean A. S. Anderson \email{sean.as.anderson@gmail.com}

}
