% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_input_data.R
\name{raster2comm}
\alias{raster2comm}
\alias{polys2comm}
\alias{points2comm}
\title{Convert raw input distribution data to community}
\usage{
raster2comm(files)

polys2comm(dat, res = 1, species = "species", trace = 1, ...)

points2comm(
  dat,
  mask = NULL,
  res = 1,
  lon = "decimallongitude",
  lat = "decimallatitude",
  species = "species",
  shp.grids = NULL,
  ...
)
}
\arguments{
\item{files}{list of raster layer objects with the same spatial
extent and resolution.}

\item{dat}{layers of merged maps corresponding to species polygons for
\code{polys2comm}; or point occurrence data frame for \code{points2comm},
with at least three columns:
\itemize{
  \item Column 1: \code{species} (listing the taxon names)
  \item Column 2: \code{decimallongitude} (corresponding to decimal longitude)
  \item Column 3: \code{decimallatitude} (corresponding to decimal latitude)
}}

\item{res}{the grain size of the grid cells in decimal degrees (default).}

\item{species}{a character string. The column with the species or taxon name.
Default = \dQuote{species}.}

\item{trace}{Trace the function; trace = 2 or higher will be more voluminous.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{mask}{Only applicable to \code{points2comm}. If supplied, a polygon
shapefile covering the boundary of the survey region.}

\item{lon}{character with the column name of the longitude.}

\item{lat}{character with the column name of the latitude.}

\item{shp.grids}{if specified, the polygon shapefile of grid cells
with a column labeled \dQuote{grids}.}
}
\value{
\itemize{
  \item comm_dat: (sparse) community matrix
  \item poly_shp: shapefile of grid cells with the values per cell.
}
}
\description{
The functions \code{points2comm}, \code{polys2comm}, \code{raster2comm}
provide convenient interfaces to convert raw distribution data often
available as point records, polygons and raster layers,
respectively, to a community composition data frame at varying spatial grains
and extents for downstream analyses.
}
\examples{
\donttest{
fdir <- system.file("NGAplants", package="phyloregion")
files <- file.path(fdir, dir(fdir))
ras <- raster2comm(files)
head(ras[[1]])
}

\donttest{
s <- readRDS(system.file("nigeria/nigeria.rds", package="phyloregion"))
sp <- random_species(100, species=5, shp=s)
pol <- polys2comm(dat = sp, species = "species", trace=0)
head(pol[[1]])
}

s <- readRDS(system.file("nigeria/nigeria.rds", package = "phyloregion"))

set.seed(1)
m <- data.frame(sp::spsample(s, 10000, type = "nonaligned"))
names(m) <- c("lon", "lat")
species <- paste0("sp", sample(1:1000))
m$taxon <- sample(species, size = nrow(m), replace = TRUE)

pt <- points2comm(dat = m, mask = s, res = 0.5, lon = "lon", lat = "lat",
            species = "taxon")
head(pt[[1]])
}
\seealso{
\code{\link[mapproj]{mapproject}} for conversion of
latitude and longitude into projected coordinates system.
\code{\link{long2sparse}} for conversion of community data.
}
