% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc_labels.R
\name{arc_labels}
\alias{arc_labels}
\alias{arc_labels.default}
\title{Add arc labels to plotted phylogeny}
\usage{
arc_labels(phy, tips, ...)

\method{arc_labels}{default}(
  phy = NULL,
  tips,
  text,
  plot_singletons = TRUE,
  ln.offset = 1.02,
  lab.offset = 1.06,
  cex = 1,
  orientation = "horizontal",
  ...
)
}
\arguments{
\item{phy}{An object of class phylo.}

\item{tips}{A character vector (or a list) with names of the
tips that belong to the clade or group. If multiple groups are
to be plotted, tips must be given in the form of a list.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{text}{Desired clade label.}

\item{plot_singletons}{Logical. If TRUE (default), adds arcs
(and labels) to single tip lineages. If FALSE, no arc or
labels will be plotted over that tip..}

\item{ln.offset}{Line offset (as a function of total tree height)}

\item{lab.offset}{Label offset.}

\item{cex}{Character expansion}

\item{orientation}{Orientation of the text. Can be \dQuote{vertical},
\dQuote{horizontal}, or \dQuote{curved}.}
}
\value{
\code{NULL}
}
\description{
Add arc labels to plotted phylogeny
}
\examples{
\donttest{
old.par <- par(no.readonly = TRUE)
require(ape)
data(africa)
par(mai=rep(0,4))
plot(africa$phylo, type = "fan", show.tip.label=FALSE,
     open.angle = 180, edge.width=0.5)

y <- data.frame(species=africa$phylo$tip.label)
y$genus <- gsub("_.*", "\\\\1", y$species)

fx <- split(y, f=y$genus)

suppressWarnings(invisible(lapply(fx, function(x) {
  y <- seq(from = 1.03, to = 1.09, by = ((1.09 - 1.03)/(length(fx) - 1)))
  z <- sample(y, 1, replace = FALSE, prob = NULL)
  if(nrow(x) > 10L) arc_labels(phy = africa$phylo, tips=x$species,
                            text=as.character(unique(x$genus)),
                            orientation = "curved", cex=0.5,
                            lab.offset = z)
})))
par(old.par)
}
}
