% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{counts}
\title{Phyloregions for functional traits and phylogeny}
\usage{
counts(x, trait, cut = NULL, phy = NULL, bin = 10, na.rm = FALSE)
}
\arguments{
\item{x}{A community data in long format with one column representing
sites labeled \dQuote{grids} and another column representing species
labeled \dQuote{species}.}

\item{trait}{A data frame or matrix object with the first column
labeled \dQuote{species} containing the taxonomic groups to be
evaluated whereas the remaining columns have the various functional
traits. The variables must be a mix of numeric and categorical values.}

\item{cut}{The slice time.}

\item{phy}{is a dated phylogenetic tree with branch lengths stored
as a phylo object (as in the ape package).}

\item{bin}{The desired number of clusters or bins.}

\item{na.rm}{Logical, whether NA values should be removed or not.}
}
\value{
Function returns a community data frame that captures the
count of each species based on its cluster membership.
}
\description{
Generates a sparse community matrix as input for clustering regions
based on the similairity of functional traits across species.
}
\keyword{bioregion}
