% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{Phylota-class}
\alias{Phylota-class}
\alias{Phylota-method}
\alias{as.character,Phylota-method}
\alias{show,Phylota-method}
\alias{print,Phylota-method}
\alias{str,Phylota-method}
\alias{summary,Phylota-method}
\alias{[[,Phylota,character-method}
\title{Phylota object}
\usage{
\S4method{as.character}{Phylota}(x)

\S4method{show}{Phylota}(object)

\S4method{print}{Phylota}(x)

\S4method{str}{Phylota}(object, max.level = 2L, ...)

\S4method{summary}{Phylota}(object)

\S4method{[[}{Phylota,character}(x, i)
}
\arguments{
\item{x}{\code{Phylota} object}

\item{object}{\code{Phylota} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}

\item{i}{Either sid or cid}
}
\description{
Phylota table contains all sequence, cluster and taxonomic
information from a phylotaR pipeline run.
}
\section{Slots}{

\describe{
\item{\code{cids}}{IDs of all clusters}

\item{\code{sids}}{IDs of all sequences}

\item{\code{txids}}{IDs of all taxa}

\item{\code{sqs}}{All sequence records as SeqArc}

\item{\code{clstrs}}{All cluster records as ClstrArc}

\item{\code{txdct}}{Taxonomic dictionary as TaxDict}

\item{\code{prnt_id}}{Parent taxonomic ID}

\item{\code{prnt_nm}}{Parent taxonomic name}
}}

\examples{
data('aotus')
# this is a Phylota object
# it contains cluster, sequence and taxonomic information from a phylotaR run
show(aotus)
# you can access its different data slots with @
aotus@cids   # cluster IDs
aotus@sids   # sequence IDs
aotus@txids  # taxonomic IDs
aotus@clstrs # clusters archive
aotus@sqs    # sequence archive
aotus@txdct  # taxonomic dictionary
# see all of the available slots
(slotNames(aotus))
# access different sequences and clusters with [[
(aotus[['0']])              # cluster record 0
(aotus[[aotus@sids[[1]]]])  # first sequence record
# get a summary of the whole object
(summary(aotus))
# the above generates a data.frame with information on each cluster:
# ID - unique id in the object
# Type - cluster type
# Seed - most connected sequence
# Parent - MRCA of all represented taxa
# N_taxa - number of NCBI recognised taxa
# N_seqs - number of sequences
# Med_sql - median sequence length
# MAD - Maximum alignment density, values close to 1 indicate all sequences in
#  the cluster have a similar length.
# Definition - most common words (and frequency) in sequence definitions
# Feature - most common feature name (and frequency)
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{TaxRec-class}}, \code{\link{clusters2_run}},
  \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
