# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

pglmm_reml_cpp <- function(par, tinvW, tH, tVphy, tX) {
    .Call(`_phyr_pglmm_reml_cpp`, par, tinvW, tH, tVphy, tX)
}

binpglmm_inter_while_cpp <- function(est_B_m, oldest_B_m, B, tol_pql, iteration_m, maxit_pql, mu, C, rcondflag, B_init, X, XX, est_B, y, n, b) {
    .Call(`_phyr_binpglmm_inter_while_cpp`, est_B_m, oldest_B_m, B, tol_pql, iteration_m, maxit_pql, mu, C, rcondflag, B_init, X, XX, est_B, y, n, b)
}

binpglmm_inter_while_cpp2 <- function(est_B_m, B, mu, C, rcondflag, B_init, X, XX, est_B, y, n, b) {
    .Call(`_phyr_binpglmm_inter_while_cpp2`, est_B_m, B, mu, C, rcondflag, B_init, X, XX, est_B, y, n, b)
}

#' Inline C++ that does most of the work related to the log-likelihood function.
#' 
#' See below for the wrapper around this function that replaces the many
#' arguments required here with one input `XPtr<LL_obj>` object.
#' 
#' 
#' @name cor_phylo_LL_
#' 
#' 
#' @noRd
#' 
#' 
NULL

#' Return reciprocal condition numbers for matrices in the log likelihood function.
#' 
#' This function is largely a repeat of the first part of the likelihood function.
#' It is used in the output to guide users wanting to change the `rcond_threshold`
#' argument.
#' 
#' 
#' @param par Initial values for the parameters to be optimized over.
#' @param ll_info A C++ `LogLikInfo` object storing all the information needed
#'     for the log likelihood function.
#' 
#' @noRd
#' 
#' @name return_rcond_vals
#' 
NULL

#' Fit cor_phylo model using nlopt.
#'
#'
#' @inheritParams ll_info cp_get_output
#' @inheritParams max_iter cor_phylo
#' @inheritParams method cor_phylo
#' 
#' @return Nothing. `ll_info` is modified in place to have info from the model fit
#'   after this function is run.
#'
#' @name fit_cor_phylo_nlopt
#' @noRd
#' 
NULL

#' Fit `cor_phylo` model using R's `stats::optim`.
#' 
#' Make sure this doesn't get run in parallel!
#'
#'
#' @inheritParams ll_info_xptr cor_phylo_LL
#' @inheritParams max_iter cor_phylo
#' @inheritParams method cor_phylo
#' 
#' @return Nothing. `ll_info_xptr` is modified in place to have info from the model fit
#'   after this function is run.
#'
#' @name fit_cor_phylo_R
#' @noRd
#' 
NULL

#' Standardize matrices in place.
#' 
#' Makes each column of the `X` matrix have mean of zero and standard deviation of 1.
#' If `U` isn't empty, this function makes each column in each matrix have
#' mean of zero and standard deviation of 1, unless all values are the same, in which
#' case it keeps the standard deviation at zero.
#' Divides each column of `M` by the original standard deviation of that column in 
#' `X`.
#' 
#' 
#' @inheritParams X cor_phylo_cpp
#' @inheritParams U cor_phylo_cpp
#' @inheritParams M cor_phylo_cpp
#' 
#' @return Nothing. Matrices are standardized in place.
#' 
#' @name standardize_matrices
#' @noRd
#' 
NULL

#' Make an `LogLikInfo` object based on input matrices.
#' 
#' The output `LogLikInfo` is used for model fitting.
#' 
#' @inheritParams X cor_phylo_cpp
#' @inheritParams U cor_phylo_cpp
#' @inheritParams M cor_phylo_cpp
#' @inheritParams Vphy_ cor_phylo_cpp
#' @inheritParams REML_ cor_phylo_cpp
#' @inheritParams constrain_d_ cor_phylo_cpp
#' @inheritParams verbose_ cor_phylo_cpp
#' 
#' @return a LogLikInfo that contains info necessary for model fitting
#' 
#' @name LogLikInfo
#' @noRd
#' 
NULL

#' Make an `LogLikInfo` object based on input matrices and another LogLikInfo object.
#' 
#' The output `LogLikInfo` is used for model fitting.
#' 
#' *Note:* This version is used for bootstrapping.
#' It's different from the one above in that it doesn't re-normalize Vphy, UU, or tau.
#' If you normalize Vphy and tau twice (which would happen if I used the previous
#' version of this constructor), it can result in weird behavior.
#' Notably, the bootstrap replicate will sometimes not converge, but when I output the
#' same data and re-run cor_phylo on it, it'll converge.
#' This is confusing, so I'm trying to avoid that.
#' 
#' 
#' @inheritParams X cor_phylo_cpp
#' @inheritParams U cor_phylo_cpp
#' @inheritParams M cor_phylo_cpp
#' @param other Another LogLikInfo object from which to derive much of the information.
#' 
#' @return a LogLikInfo that contains info necessary for model fitting
#' 
#' @name LogLikInfo
#' @noRd
#' 
NULL

#' Retrieve objects for output `cor_phylo` object.
#' 
#' @inheritParams X cor_phylo_cpp
#' @inheritParams U cor_phylo_cpp
#' @param ll_info an LogLikInfo object that contains info necessary to fit the model.
#'   After optimization, it contains info from the model fit.
#' 
#' @return a list containing output information, to later be coerced to a `cor_phylo`
#'   object by the `cor_phylo` function.
#' 
#' @name cp_get_output
#' @noRd
#' 
NULL

#' Iterate from a BootMats object in prep for a bootstrap replicate.
#' 
#' This ultimately updates the LogLikInfo object with new XX and MM matrices,
#' and updates the BootResults object with the mean and sd.
#' 
#' @param ll_info An LogLikInfo object that will inform the next call to the
#'     log-likelihood function.
#' @param br A BootResults object that stores output from bootstrapping.
#' 
#' @name boot_mats_iterate
#' @noRd
#' 
NULL

#' `cor_phylo` log likelihood function.
#' 
#' 
#' @param par Initial values for the parameters to be optimized over.
#' @param ll_info_xptr `Rcpp::Xptr` object that points to a C++ `LogLikInfo` object.
#'     This object stores all the other information needed for the log likelihood
#'     function.
#' 
#' @noRd
#' 
#' @name cor_phylo_LL
#' 
cor_phylo_LL <- function(par, XX, UU, MM, Vphy, tau, REML, constrain_d, lower_d, verbose, rcond_threshold) {
    .Call(`_phyr_cor_phylo_LL`, par, XX, UU, MM, Vphy, tau, REML, constrain_d, lower_d, verbose, rcond_threshold)
}

#' Inner function to create necessary matrices and do model fitting.
#' 
#' @param X a n x p matrix with p columns containing the values for the n taxa.
#' @param U a list of p matrices corresponding to the p columns of `X`, with each 
#'   matrix containing independent variables for the corresponding column of `X`.
#' @param M a n x p matrix with p columns containing standard errors of the trait 
#'   values in `X`. 
#' @param Vphy_ phylogenetic variance-covariance matrix from the input phylogeny.
#' @inheritParams REML cor_phylo
#' @inheritParams constrain_d cor_phylo
#' @inheritParams verbose cor_phylo
#' @inheritParams max_iter cor_phylo
#' @param method the `method` input to `cor_phylo`.
#' 
#' @return a list containing output information, to later be coerced to a `cor_phylo`
#'   object by the `cor_phylo` function.
#' @noRd
#' @name cor_phylo_cpp
#' 
cor_phylo_cpp <- function(X, U, M, Vphy_, REML, constrain_d, lower_d, verbose, rcond_threshold, rel_tol, max_iter, method, no_corr, boot, keep_boots, sann) {
    .Call(`_phyr_cor_phylo_cpp`, X, U, M, Vphy_, REML, constrain_d, lower_d, verbose, rcond_threshold, rel_tol, max_iter, method, no_corr, boot, keep_boots, sann)
}

set_seed <- function(seed) {
    invisible(.Call(`_phyr_set_seed`, seed))
}

predict_cpp <- function(n, nsr, reps, V) {
    .Call(`_phyr_predict_cpp`, n, nsr, reps, V)
}

pcd2_loop <- function(SSii, nsr, SCii, comm, V, nsp_pool, verbose) {
    .Call(`_phyr_pcd2_loop`, SSii, nsr, SCii, comm, V, nsp_pool, verbose)
}

pglmm_iV_logdetV_cpp <- function(par, mu, Zt, St, nested, logdet, family, totalSize) {
    .Call(`_phyr_pglmm_iV_logdetV_cpp`, par, mu, Zt, St, nested, logdet, family, totalSize)
}

pglmm_V <- function(par, Zt, St, mu, nested, missing_mu, family, totalSize) {
    .Call(`_phyr_pglmm_V`, par, Zt, St, mu, nested, missing_mu, family, totalSize)
}

pglmm_LL_cpp <- function(par, H, X, Zt, St, mu, nested, REML, verbose, family, totalSize) {
    .Call(`_phyr_pglmm_LL_cpp`, par, H, X, Zt, St, mu, nested, REML, verbose, family, totalSize)
}

pglmm_internal_cpp <- function(X, Y, Zt, St, nested, REML, verbose, n, p, q, maxit, reltol, tol_pql, maxit_pql, optimizer, B_init, ss, family, totalSize) {
    .Call(`_phyr_pglmm_internal_cpp`, X, Y, Zt, St, nested, REML, verbose, n, p, q, maxit, reltol, tol_pql, maxit_pql, optimizer, B_init, ss, family, totalSize)
}

sexp_type <- function(x) {
    .Call(`_phyr_sexp_type`, x)
}

pglmm_gaussian_predict <- function(iV, H) {
    .Call(`_phyr_pglmm_gaussian_predict`, iV, H)
}

pglmm_gaussian_LL_cpp <- function(par, X, Y, Zt, St, nested, REML, verbose) {
    .Call(`_phyr_pglmm_gaussian_LL_cpp`, par, X, Y, Zt, St, nested, REML, verbose)
}

pglmm_gaussian_LL_calc_cpp <- function(par, X, Y, Zt, St, nested, REML) {
    .Call(`_phyr_pglmm_gaussian_LL_calc_cpp`, par, X, Y, Zt, St, nested, REML)
}

pglmm_gaussian_internal_cpp <- function(par, X, Y, Zt, St, nested, REML, verbose, optimizer, maxit, reltol, q, n, p, Pi) {
    .Call(`_phyr_pglmm_gaussian_internal_cpp`, par, X, Y, Zt, St, nested, REML, verbose, optimizer, maxit, reltol, q, n, p, Pi)
}

which2 <- function(x) {
    .Call(`_phyr_which2`, x)
}

vcv_loop <- function(xx, n, e1, e2, EL, pp, corr) {
    .Call(`_phyr_vcv_loop`, xx, n, e1, e2, EL, pp, corr)
}

cov2cor_cpp <- function(vcv) {
    invisible(.Call(`_phyr_cov2cor_cpp`, vcv))
}

pse_cpp <- function(comm, Cmatrix) {
    .Call(`_phyr_pse_cpp`, comm, Cmatrix)
}

psv_cpp <- function(comm, Cmatrix, compute_var) {
    .Call(`_phyr_psv_cpp`, comm, Cmatrix, compute_var)
}

