% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{squish_whitespace}
\alias{squish_whitespace}
\title{Remove Extra Whitespace}
\usage{
squish_whitespace(text, remove_terminal_hyphens = TRUE)
}
\arguments{
\item{text}{A character vector to clean.}

\item{remove_terminal_hyphens}{Logical; should hyphens at the end of lines
after a word be removed? For example, "un-\\nbroken" would become
"unbroken".}
}
\value{
The character vector with spacing at the start and end removed, and
with internal spacing reduced to a single space character each.
}
\description{
This function is mostly a wrapper around \code{\link[stringr]{str_squish}},
with the additional option to remove hyphens at the ends of lines.
}
\examples{
sample_text <- "This  had many space char-\\\\nacters."
squish_whitespace(sample_text)
}
