% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infCrit.R
\name{infCrit}
\alias{infCrit}
\title{Information criterion values for SEM}
\usage{
infCrit(
  modelList,
  Cstat,
  add.claims = NULL,
  basis.set = NULL,
  direction = NULL,
  conserve = FALSE,
  conditional = FALSE,
  .progressBar = FALSE
)
}
\arguments{
\item{modelList}{a list of structural equations}

\item{Cstat}{Fisher's C statistic obtained from \code{fisherC}}

\item{add.claims}{an optional vector of additional independence claims (P-values) 
to be added to the basis set}

\item{basis.set}{An optional list of independence claims.}

\item{direction}{a vector of claims defining the specific directionality of any independence 
claim(s)}

\item{conserve}{whether the most conservative P-value should be returned (See Details) 
Default is FALSE}

\item{conditional}{whether the conditioning variables should be shown in the table. 
Default is FALSE}

\item{.progressBar}{an optional progress bar. Default is FALSE}
}
\value{
a vector of AIC, AICc, BIC, d.f., and sample size
}
\description{
Information criterion values for SEM
}
