% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.R
\name{coefs}
\alias{coefs}
\title{Extract path coefficients}
\usage{
coefs(
  modelList,
  standardize = "scale",
  standardize.type = "latent.linear",
  test.statistic = "F",
  test.type = "II",
  intercepts = FALSE
)
}
\arguments{
\item{modelList}{A list of structural equations, or a model.}

\item{standardize}{The type of standardization: \code{none}, \code{scale}, \code{range}.
Default is \code{scale}.}

\item{standardize.type}{The type of standardized for non-Gaussian responses:
\code{latent.linear}, \code{Menard.OE}. Default is \code{latent.linear} for binomial; 
otherwise it is \code{Menard.OE}.}

\item{test.statistic}{the type of test statistic generated by \code{Anova}}

\item{test.type}{the type of test for significance of categorical variables
from \code{Anova}. Default is type "II".}

\item{intercepts}{Whether intercepts should be included in the coefficients
table. Default is FALSE.}
}
\value{
Returns a \code{data.frame} of coefficients, their standard errors,
degrees of freedom, and significance tests.
}
\description{
Extracts (standardized) path coefficients from a \code{psem} object.
}
\details{
P-values for models constructed using \code{lme4} are obtained
using the Kenward-Roger approximation of the denominator degrees of freedom
as implemented in the \code{Anova} function.

Different forms of standardization can be implemented using the \code{standardize}
argument:\itemize{
\item{\code{none} No standardized coefficients are reported.}
\item{\code{scale} Raw coefficients are scaled by the ratio of the standard deviation
of x divided by the standard deviation of y. See below for cases pertaining to GLM. }
\item{\code{range} Raw coefficients are scaled by a pre-selected range of x
divided by a preselected range of y. The default argument is \code{range} which takes the
two extremes of the data, otherwise the user must supply must a named \code{list} where
the names are the variables to be standardized, and each entry contains a vector of 
length == 2 to the ranges to be used in standardization.}
}

For non-Gaussian responses, standardized coefficients are obtained in one of two ways:
\itemize{ \item{\code{latent.linear} Referred to in Grace et al. 2019 as the standard form of
the latent-theoretic (LT) approach. In this method, there is assumed to be a continuous 
latent propensity, y*, that underlies the observed binary responses. The standard
deviation of y* is computed as the square-root of the variance of the predictions
(on the linear or 'link' scale) plus the distribution-specific theoretical variance in the
case of binomial responses (for logit links: pi^2/3, for probit links: 1).}
\item{\code{Menard.OE} Referred to in Grace et al. 2019 as the standard form of
the observed-empirical (OE) approach. In this method, error variance is based on the
differences between predicted scores and the observed binary data. The standard
deviation used for standardization is computed as the square-root of the variance of
the predictions (on the linear scale) plus the correlation between the observed and
predicted (on the original or 'response' scale) values of y.}
}

For categorical predictors: significance is determined using ANOVA (or analysis of
deviance). Because n-1 coefficients are reported for n levels, the output instead
reports model-estimated means in the \code{Estimate} column. This is done so all
n paths in the corresponding path diagram have assignable values.

The means are generated using function \code{emmeans} in the \code{emmeans} package. 
Pairwise contrasts are further conducted among all levels using the default  
correction for multiple testing. The results of those comparisons are given in the 
significance codes (e.g., "a", "b", "ab") as reported in the \code{multcomp::cld} function.

For non-linear variables (i.e., smoothing functions from \code{mgcv::gam}), there are
no linear estimates reported.
}
\examples{
mod <- psem(
lm(rich ~ cover, data = keeley),
lm(cover ~ firesev, data = keeley),
lm(firesev ~ age, data = keeley),
data = keeley
)

coefs(mod)

}
\references{
Grace, J.B., Johnson, D.A., Lefcheck, J.S., and Byrnes, J.E.
"Standardized Coefficients in Regression and Structural Models with Binary Outcomes." 
Ecosphere 9(6): e02283.
}
\seealso{
\code{\link{Anova}}, \code{\link[emmeans]{emmeans}}, \code{\link[multcomp]{cld}}
}
\author{
Jon Lefcheck <LefcheckJ@si.edu>, Jim Grace
}
