% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_datatxt.R
\name{legacy_datatxt}
\alias{legacy_datatxt}
\alias{board_register_datatxt}
\title{Remote "data.txt" board (legacy API)}
\usage{
legacy_datatxt(
  url,
  headers = NULL,
  cache = board_cache_path(name),
  needs_index = TRUE,
  browse_url = url,
  index_updated = NULL,
  index_randomize = FALSE,
  path = NULL,
  versions = FALSE,
  name = NULL,
  ...
)

board_register_datatxt(
  url,
  name = NULL,
  headers = NULL,
  cache = board_cache_path(name),
  ...
)
}
\arguments{
\item{url}{Path to the \code{data.txt} file or directory containing it.}

\item{headers}{Optional list of headers to include or a function to generate them.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{needs_index}{Does this board have an index file?}

\item{browse_url}{Not currently used}

\item{index_updated}{Callback function used to update index}

\item{index_randomize}{When retrieving \code{data.txt} at a parameter with random
query string to defeat caching?}

\item{path}{Subdirectory within \code{url}}

\item{versions}{Should this board be registered with support for versions?}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Use board that for a website that uses the \href{https://datatxt.org}{data.txt}
specification. A \code{data.txt} file is a YAML that provides some basic metadata
about a directory of files.
}
\examples{

# register website board using datatxt file
board_register_datatxt(
  url = "https://datatxt.org/data.txt",
  name = "txtexample",
  cache = tempfile()
)

# find pins
pin_find(board = "txtexample")
}
