% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_gcs.R
\name{board_gcs}
\alias{board_gcs}
\title{Use a Google Cloud Storage bucket as a board}
\usage{
board_gcs(bucket, prefix = NULL, versioned = TRUE, cache = NULL)
}
\arguments{
\item{bucket}{Bucket name. You can only write to an existing bucket, and you
can use \code{\link[googleCloudStorageR:gcs_get_global_bucket]{googleCloudStorageR::gcs_get_global_bucket()}} here.}

\item{prefix}{Prefix within this bucket that this board will occupy.
You can use this to maintain multiple independent pin boards within
a single GCS bucket. Will typically end with \code{/} to take advantage of
Google Cloud Storage's directory-like handling.}

\item{versioned}{Should this board be registered with support for versions?}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}
}
\description{
Pin data to a Google Cloud Storage bucket using the googleCloudStorageR
package.
}
\section{Authentication}{
\code{board_gcs()} is powered by the googleCloudStorageR package which provides
several authentication options, as documented in its
\href{https://code.markedmondson.me/googleCloudStorageR/articles/googleCloudStorageR.html}{main vignette}.
The two main options are to create a service account key (a JSON file) or an
authentication token; you can manage either using the \href{https://gargle.r-lib.org/}{gargle} package.
}

\section{Details}{
\itemize{
\item The functions in pins do not create a new bucket. You can create
a new bucket from R with \code{\link[googleCloudStorageR:gcs_create_bucket]{googleCloudStorageR::gcs_create_bucket()}}.
\item You can pass arguments for \link[googleCloudStorageR:gcs_upload]{googleCloudStorageR::gcs_upload} such as
\code{predefinedAcl} and \code{upload_type} through the dots of \code{pin_write()}.
\item \code{board_gcs()} is powered by the googleCloudStorageR package, which is a
suggested dependency of pins (not required for pins in general). If
you run into errors when deploying content to a server like
\url{https://www.shinyapps.io} or \href{https://posit.co/products/enterprise/connect/}{Connect},
add \code{requireNamespame(googleCloudStorageR)} to your app or document for \href{https://docs.posit.co/connect/user/troubleshooting/#render-missing-r-package}{automatic dependency discovery}.
}
}

\examples{
\dontrun{
board <- board_gcs("pins-testing")
board \%>\% pin_write(mtcars)
board \%>\% pin_read("mtcars")

# A prefix allows you to have multiple independent boards in the same pin.
board_sales <- board_gcs("company-pins", prefix = "sales/")
board_marketing <- board_gcs("company-pins", prefix = "marketing/")
# You can make the hierarchy arbitrarily deep.

# Pass arguments like `predefinedAcl` through the dots of `pin_write`:
board \%>\% pin_write(mtcars, predefinedAcl = "publicRead")
}
}
