% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{inv_transform_response}
\alias{inv_transform_response}
\title{Inverse transform machine learning response variable}
\usage{
inv_transform_response(.f)
}
\arguments{
\item{.f}{A unary function of a data.frame that returns a new data.frame containing only the
inverse transformed response variable. An error will be thrown if this is not the case.}
}
\value{
A unary function of a data.frame that returns the input data.frame with the inverse
transformed response variable column appended. This function is assigned the classes
\code{"inv_transform_response"} and \code{"ml_pipeline_section"}.
}
\description{
A function that takes as its arguement another function defining a inverse response variable
transformation, and wraps (or adapts) it for use within a machine learning pipeline.
}
\examples{
data <- head(faithful)
f1 <- transform_response(function(df) {
  data.frame(y = (df$eruptions - mean(df$eruptions)) / sd(df$eruptions))
})
f2 <- inv_transform_response(function(df) {
  data.frame(eruptions2 = df$y * sd(df$eruptions) + mean(df$eruptions))
})

f2(f1(data))
#   eruptions waiting          y eruptions2
# 1     3.600      79  0.5412808      3.600
# 2     1.800      54 -1.3039946      1.800
# 3     3.333      74  0.2675649      3.333
# 4     2.283      62 -0.8088457      2.283
# 5     4.533      85  1.4977485      4.533
# 6     2.883      55 -0.1937539      2.883
}

