% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m325beta.R
\name{m325beta}
\alias{m325beta}
\title{Minenergo-325. Local heat loss coefficient}
\usage{
m325beta(laying = "channel", d = 700)
}
\arguments{
\item{laying}{type of pipe laying depicting the position of pipe in space:
\itemize{
  \item \code{air},
  \item \code{channel},
  \item \code{room},
  \item \code{tunnel},
  \item \code{underground}.
}
Type: \code{\link{assert_subset}}.}

\item{d}{internal diameter of pipe, [\emph{mm}]. Type: \code{\link{assert_double}}.}
}
\value{
Two possible values of \eqn{\beta}: \code{1.2} or \code{1.15} depending on
 pipe laying and its diameter. Type: \code{\link{assert_double}}.
}
\description{
Calculate \eqn{\beta} - \emph{local heat loss coefficient} according to rule \emph{11.3.3}
 of \href{https://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
 \emph{Local heat loss coefficient} is used to increase normative heat loss
 of pipe by taking into account heat loss of fittings (shut-off valves,
 compensators and supports). This coefficient is applied mostly as a factor
 during the summation of heat losses of pipes in pipeline leveraging
 formula 14 of \href{https://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
}
\examples{
 library(pipenostics)

norms <- within(m325nhldata, {
  beta <- m325beta(laying, as.double(diameter))
})
unique(norms$beta)
# [1] 1.15 1.20

}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m278soildata}},
\code{\link{m325nhl}()},
\code{\link{m325nhldata}},
\code{\link{m325testbench}}
}
\concept{Minenergo}
