% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteos.R
\name{meteos}
\alias{meteos}
\title{Get list of weather stations (meteos)}
\usage{
meteos()
}
\value{
list of weather stations (meteos) with the next fields:
 \describe{
   \item{\code{station_id}}{Weather station unique identifier. Type: \code{\link{assert_integer}}.}
   \item{\code{name}}{Human-readable name of weather station. Type: \code{\link{assert_character}}.}
   \item{\code{lat}}{Geographical position of wether station. Latitude, [\emph{DD}]. Type: \code{\link{assert_double}}.}
   \item{\code{lon}}{Geographical position of wether station. Longitude, [\emph{DD}]. Type: \code{\link{assert_double}}.}
   \item{\code{alt}}{Altitude - position of weather station above sea level, [m]. Type: \code{\link{assert_double}}.}
   \item{\code{avg}}{Mean annual ground temperature averaged over depth, [\emph{°C}]. Type: \code{\link{assert_double}}.}
 }
 Type: \code{\link{assert_data_frame}}.
}
\description{
Get a list of weather stations located primarily in the
 central and northern parts of Eurasia. For each weather station, the 
 following information is provided: an integer station ID, geographic 
 coordinates, altitude, and the mean annual ground temperature averaged over
 depth.
}
\examples{
 library(pipenostics)
 head(meteos())

}
\references{
\href{http://meteo.ru/structure/lipik/}{Climate Change Investigation Laboratory}.
 Description of the array of daily data on soil temperature at depths up to 320 centimeters
 by meteorological stations of the \emph{Russian Federation}.
}
\seealso{
\code{\link{mgtdhid}} to get hourly ground temperature values at different 
 depths measured at the listed weather stations.

Other utils: 
\code{\link{geoarea}()},
\code{\link{mgtdhid}()},
\code{\link{wth_d}()}
}
\concept{utils}
