% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piqp.R
\name{piqp}
\alias{piqp}
\title{PIQP Solver object}
\usage{
piqp(
  P = NULL,
  c = NULL,
  A = NULL,
  b = NULL,
  G = NULL,
  h = NULL,
  x_lb = NULL,
  x_ub = NULL,
  settings = list(),
  backend = c("auto", "sparse", "dense")
)
}
\arguments{
\item{P}{dense or sparse matrix of class dgCMatrix or coercible into such, must be positive semidefinite}

\item{c}{numeric vector}

\item{A}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{b}{numeric vector}

\item{G}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{h}{numeric vector}

\item{x_lb}{a numeric vector of lower bounds, default \code{NULL}
indicating \code{-Inf} for all variables, otherwise should be number
of variables long}

\item{x_ub}{a numeric vector of upper bounds, default \code{NULL}
indicating \code{Inf} for all variables, otherwise should be number of
variables long}

\item{settings}{list with optimization parameters, empty by default; see \code{\link[=piqp_settings]{piqp_settings()}} for a comprehensive list of parameters that may be used}

\item{backend}{which backend to use, if auto and P, A or G are sparse then sparse backend is used (\code{"auto"}, \code{"sparse"} or \code{"dense"}) (\code{"auto"})}
}
\value{
An R6-object of class "piqp_model" with methods defined which can be further
used to solve the problem with updated settings / parameters.
}
\description{
PIQP Solver object
}
\details{
Allows one to solve a parametric
problem with for example warm starts between updates of the parameter, c.f. the examples.
The object returned by \code{piqp} contains several methods which can be used to either update/get details of the
problem, modify the optimization settings or attempt to solve the problem.
}
\section{Usage}{

\preformatted{model = piqp(P = NULL, c = NULL, A = NULL, b = NULL, G = NULL, h = NULL, x_lb = NULL, x_ub = NULL, settings = piqp_settings(), backend = c("auto", "sparse", "dense"))

model$solve()
model$update(P = NULL, c = NULL, A = NULL, b = NULL, G = NULL, h = NULL, x_lb = NULL, x_ub = NULL)
model$get_settings()
model$get_dims()
model$update_settings(new_settings = piqp_settings())

print(model)
}
}

\examples{
## example, adapted from PIQP documentation
library(piqp)
library(Matrix)

P <- Matrix(c(6., 0.,
              0., 4.), 2, 2, sparse = TRUE)
c <- c(-1., -4.)
A <- Matrix(c(1., -2.), 1, 2, sparse = TRUE)
b <- c(1.)
G <- Matrix(c(1., 2., -1., 0.), 2, 2, sparse = TRUE)
h <- c(0.2, -1.)
x_lb <- c(-1., -Inf)
x_ub <- c(1., Inf)

settings <- list(verbose = TRUE)

model <- piqp(P, c, A, b, G, h, x_lb, x_ub, settings)

# Solve
res <- model$solve()
res$x

# Define new data
A_new <- Matrix(c(1., -3.), 1, 2, sparse = TRUE)
h_new <- c(2., 1.)

# Update model and solve again
model$update(A = A_new, h = h_new)
res <- model$solve()
res$x

}
\seealso{
\code{\link[=solve_piqp]{solve_piqp()}},  \code{\link[=piqp_settings]{piqp_settings()}}
}
