% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sim_twal_with_std_nsm_fun.R
\name{get_sim_twal_with_std_nsm_fun}
\alias{get_sim_twal_with_std_nsm_fun}
\title{Get a function to simulate a twin alignment which uses a standard
site model}
\usage{
get_sim_twal_with_std_nsm_fun(
  mutation_rate = 0.1,
  site_model = beautier::create_jc69_site_model()
)
}
\arguments{
\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{site_model}{a nucleotide substitution model,
which can be:
\itemize{
  \item{
    A standard nucloetide substitution model,
    as created by \link[beautier]{create_site_model}
  }
  \item{
    \code{lns}: a linked node-substitution model
  }
  \item{
    \code{uns}: an unlinked node-substitution model
  }
}}
}
\value{
a partially evaluated function of
\link{sim_twal_with_std_nsm}
}
\description{
Get a function to simulate a twin alignment which uses a standard
site model
}
\examples{

f <- get_sim_twal_with_std_nsm_fun(
  mutation_rate = 0.1
)
# This adapter function must be a sim_twin_alignment function
check_sim_twal_fun(f)

# Simulate a twin DNA alignment

alignment <- f(
  twin_phylogeny = ape::read.tree(text = "((A:1, B:1):2, C:3);"),
  root_sequence = "aaaa"
)
check_alignment(alignment)
}
\seealso{
See \link{check_sim_twal_fun} to the the other
functions to simulate a twin alignment.
Use \link{sim_twin_alignment} to use this function to
create a twin alignment.
}
