% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_to_tables.R
\name{pir_to_tables}
\alias{pir_to_tables}
\title{Create all tables to checks \link{pirouette} pipeline}
\usage{
pir_to_tables(pir_params, folder = tempdir())
}
\arguments{
\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}

\item{folder}{folder where the files are stored in.
By default, this is a temporary folder}
}
\value{
the names of all files created
}
\description{
Create all tables to checks \link{pirouette} pipeline
}
\examples{
if (beautier::is_on_ci() && beastier::is_beast2_installed()) {
  pir_params <- init_pir_params(create_test_pir_params())

  # Run only the true tree part
  pir_run_true_tree(
    true_phylogeny = ape::rcoal(4),
    pir_params = pir_params
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
