% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_error_measure_params.R
\name{create_error_measure_params}
\alias{create_error_measure_params}
\title{Create the parameters to specify how the error
between the given phylogeny and the Bayesian posterior trees is measured.}
\usage{
create_error_measure_params(
  burn_in_fraction = 0.1,
  error_fun = get_nltt_error_fun()
)
}
\arguments{
\item{burn_in_fraction}{the fraction of the posterior trees (starting
from the ones generated first)
that will be discarded,
must be a value from 0.0 (keep all), to 1.0 (discard all).}

\item{error_fun}{function that determines the error between
a given phylogeny and a the trees in a Bayesian posterior.
The function must have two arguments:
\itemize{
  \item the one given phylogeny, of class \link[ape]{phylo}
  \item one or more posterior trees, of class \link[ape]{multiphylo}
}
The function must return as many errors as there are posterior
trees given. The error must be lowest between identical trees.
Example functions are:
\itemize{
  \item \link{get_gamma_error_fun}: use the absolute difference
    in gamma statistic
  \item \link{get_nltt_error_fun}: use the nLTT statistic
}}
}
\value{
an error measurement parameter set
}
\description{
Create the parameters to specify how the error
between the given phylogeny and the Bayesian posterior trees is measured.
}
\examples{
if (beautier::is_on_ci()) {

  # Default
  error_measure_params <- create_error_measure_params()

  # Use the nLTT statistic with a burn-in of 10\%
  error_measure_params <- create_error_measure_params(
    burn_in_fraction = 0.1,
    error_fun = get_nltt_error_fun()
  )

  # Use the gamma statistic with a burn-in of 20\%
  error_measure_params <- create_error_measure_params(
    burn_in_fraction = 0.2,
    error_fun = get_gamma_error_fun()
  )

  pir_params <- create_pir_params(
    alignment_params = create_test_alignment_params(),
    experiments = list(create_test_gen_experiment()),
    error_measure_params = error_measure_params
  )

  if (rappdirs::app_dir()$os != "win" &&
    beautier::is_on_ci() && is_beast2_installed()
  ) {
    pir_out <- pir_run(
      phylogeny = ape::read.tree(text = "((A:2, B:2):1, C:3);"),
      pir_params = pir_params
    )
    pir_plot(pir_out)
  }
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
