% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotCalculationGroups.R
\docType{class}
\name{PivotCalculationGroups}
\alias{PivotCalculationGroups}
\title{A class that contains multiple calculation groups.}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}}.
}
\description{
The PivotCalculationGroups class stores all of the calculation groups for a
pivot table.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new container for pivot table calculation
  groups, specifying the field values documented above.}

  \item{\code{isExistingCalculationGroup(calculationGroupName)}}{Check if a
  calculation group exists with the specified name.}
  \item{\code{getCalculationGroup(calculationGroupName)}}{Get the calculation
  group with the specified name.}
  \item{\code{addCalculationGroup(calculationGroupName)}}{Create a new
  calculation group with the specified name.}
  \item{\code{asList()}}{Get a list representation of these calculation
  groups.}
  \item{\code{asJSON()}}{Get a JSON representation of these calculation
  groups.}
  \item{\code{asString()}}{Get a text representation of these calculation
  groups.}
}
}

\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
