% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_bookdown.R
\name{sprinkle_bookdown}
\alias{sprinkle_bookdown}
\alias{sprinkle_bookdown.default}
\alias{sprinkle_bookdown.dust_list}
\title{Change the Bookdown Property in a Dust Table}
\source{
\url{https://bookdown.org/yihui/bookdown/tables.html}
}
\usage{
sprinkle_bookdown(x, bookdown = getOption("pixie_bookdown", FALSE), ...)

\method{sprinkle_bookdown}{default}(x, bookdown = getOption("pixie_bookdown",
  FALSE), ...)

\method{sprinkle_bookdown}{dust_list}(x,
  bookdown = getOption("pixie_bookdown", FALSE), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{bookdown}{\code{logical(1)} indicating if the table is being produced
in a \code{bookdown} document.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Tables built for the \code{bookdown} package can be referenced
  in a manner that is consistent between HTML and LaTeX documents.
}
\details{
\code{bookdown} is a package that facilitates the writing of books.
  One of the advantages of \code{bookdown} is the ability to reference 
  tables in a manner similar to LaTeX. The key difference in how 
  \code{pixiedust} handles output is the reference specification. See 
  \url{https://bookdown.org/yihui/bookdown/tables.html} for details on how
  \code{bookdown} uses labels and references.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{bookdown} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{bookdown} is not a logical object.
 \item Cast an error if \code{bookdown} has length greater than 1.
}
}

\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}
\author{
Benjamin Nutter
}
