% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgdiff.R
\docType{package}
\name{pkgdiff}
\alias{pkgdiff}
\alias{pkgdiff-package}
\title{Identify Differences Between Package Versions}
\description{
The \strong{pkgdiff} package contains functions to
identify differences between versions of R packages. The \strong{pkgdiff}
package was written specifically to detect breaking changes and
help with package upgrades.
}
\section{Functions}{

The main functions included in the \strong{pkgdiff} package are
as follows:
\itemize{
\item {\code{\link{pkg_info}}: Retrieves general information about a package,
mostly from the package description file.}
\item {\code{\link{pkg_versions}}: Gets a data frame containing all
versions of a package and the release date for each.}
\item {\code{\link{pkg_diff}}: Compares two package versions, and
returns an object that contains the differences in terms of exported
function signatures.}
\item {\code{\link{pkg_stability}}: Compiles information on package
stability over time, and calculates a score based on this information.
This function is useful when making package selection choices.}
\item {\code{\link{pkg_repo}}: Fetches package names and versions for
packages in a specified repository.}
\item {\code{\link{repo_breakages}}: Identifies breakages when
upgrading from one version of a repository to another.}
\item {\code{\link{repo_stability}}: Performs a stability assessment
on multiple packages, even an entire repository.}
}
For additional information on \strong{pkgdiff}, see the package vignette
\code{vignette('pkgdiff')}, or visit the package web site
\href{https://pkgdiff.r-sassy.org/index.html}{here}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://pkgdiff.r-sassy.org}
  \item \url{https://github.com/dbosak01/pkgdiff}
  \item Report bugs at \url{https://github.com/dbosak01/pkgdiff/issues}
}

}
\author{
\strong{Maintainer}: David Bosak \email{dbosak01@gmail.com}

Other contributors:
\itemize{
  \item Brian Varney \email{brian.varney@experis.com} [contributor]
  \item Kevin Putschko \email{kevin.putschko@experis.com} [contributor]
}

}
\keyword{internal}
