% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_all}
\alias{load_all}
\alias{is_loading}
\title{Load complete package}
\usage{
load_all(
  path = ".",
  reset = TRUE,
  compile = NA,
  attach = TRUE,
  export_all = TRUE,
  export_imports = export_all,
  helpers = export_all,
  attach_testthat = uses_testthat(path),
  quiet = NULL,
  recompile = FALSE,
  warn_conflicts = TRUE
)

is_loading(pkg = NULL)
}
\arguments{
\item{path}{Path to a package, or within a package.}

\item{reset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This is no longer supported
because preserving the namespace requires unlocking its environment, which
is no longer possible in recent versions of R.}

\item{compile}{If \code{TRUE} always recompiles the package; if \code{NA}
recompiles if needed (as determined by \code{\link[pkgbuild:needs_compile]{pkgbuild::needs_compile()}});
if \code{FALSE}, never recompiles.}

\item{attach}{Whether to attach a package environment to the search
path. If \code{FALSE} \code{load_all()} behaves like \code{loadNamespace()}. If
\code{TRUE} (the default), it behaves like \code{library()}. If \code{FALSE},
the \code{export_all}, \code{export_imports}, and \code{helpers} arguments have
no effect.}

\item{export_all}{If \code{TRUE} (the default), export all objects.
If \code{FALSE}, export only the objects that are listed as exports
in the NAMESPACE file.}

\item{export_imports}{If \code{TRUE} (the default), export all objects that are
imported by the package. If \code{FALSE} export only objects defined in the
package.}

\item{helpers}{if \code{TRUE} loads \pkg{testthat} test helpers.}

\item{attach_testthat}{If \code{TRUE}, attach \pkg{testthat} to the search path,
which more closely mimics the environment within test files.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{recompile}{DEPRECATED. force a recompile of DLL from source code, if
present. This is equivalent to running \code{\link[pkgbuild:clean_dll]{pkgbuild::clean_dll()}} before
\code{load_all()}}

\item{warn_conflicts}{If \code{TRUE}, issues a warning if a function in the global
environment masks a function in the package. This can happen when you
accidentally source a \code{.R} file, rather than using \code{load_all()}, or if you
define a function directly in the R console. This is frustrating to debug,
as it feels like the changes you make to the package source aren't having
the expected effect.}

\item{pkg}{If supplied, \code{is_loading()} only returns \code{TRUE} if the
package being loaded is \code{pkg}.}
}
\description{
\code{load_all()} loads a package. It roughly simulates what happens
when a package is installed and loaded with \code{\link[=library]{library()}}, without
having to first install the package. It:
\itemize{
\item Loads all data files in \verb{data/}. See \code{\link[=load_data]{load_data()}} for more
details.
\item Sources all R files in the R directory, storing results in
environment that behaves like a regular package namespace. See
\code{\link[=load_code]{load_code()}} for more details.
\item Adds a shim from \code{\link[=system.file]{system.file()}} to \code{\link[=shim_system.file]{shim_system.file()}} in
the imports environment of the package. This ensures that \code{system.file()}
works with both development and installed packages despite their differing
directory structures.
\item Adds shims from \code{help()} and \verb{?} to \code{\link[=shim_help]{shim_help()}} and \code{\link[=shim_question]{shim_question()}}
to make it easier to preview development documentation.
\item Compiles any C, C++, or Fortran code in the \verb{src/} directory and
connects the generated DLL into R. See \code{\link[pkgbuild:compile_dll]{pkgbuild::compile_dll()}}
for more details.
\item Loads any compiled translations in \code{inst/po}.
\item Runs \code{.onAttach()}, \code{.onLoad()} and \code{.onUnload()} functions at
the correct times.
\item If you use \pkg{testthat}, will load all test helpers so you can
access them interactively. devtools sets the \code{DEVTOOLS_LOAD}
environment variable to the package name to let you check whether the
helpers are run during package loading.
}

\code{is_loading()} returns \code{TRUE} when it is called while \code{load_all()}
is running. This may be useful e.g. in \code{.onLoad} hooks.
A package loaded with \code{load_all()} can be identified with with
\code{\link[=is_dev_package]{is_dev_package()}}.
}
\section{Differences to regular loading}{
\code{load_all()} tries its best to reproduce the behaviour of
\code{\link[=loadNamespace]{loadNamespace()}} and \code{\link[=library]{library()}}. However it deviates from normal
package loading in several ways.
\itemize{
\item \code{load_all()} doesn't install the package to a library, so \code{\link[=system.file]{system.file()}}
doesn't work. pkgload fixes this for the package itself installing a shim,
\code{\link[=shim_system.file]{shim_system.file()}}. However, this shim is not visible to third party
packages, so they will fail if they attempt to find files within your
package. One potential workaround is to use \code{\link[fs:path_package]{fs::path_package()}}
instead of \code{system.file()}, since that understands the mechanisms that
devtools uses to load packages.
\item \code{load_all()} loads all packages referenced in \code{Imports} at load time,
but \code{loadNamespace()} and \code{library()} only load package dependencies as
they are needed.
\item \code{load_all()} copies all objects (not just the ones listed as exports)
into the package environment. This is useful during development because
it makes internal objects easy to access.  To export only the objects
listed as exports, use \code{export_all = FALSE}. This more closely simulates
behavior when loading an installed package with \code{\link[=library]{library()}}, and can
be useful for checking for missing exports.
}
}

\examples{
\dontrun{
# Load the package in the current directory
load_all("./")

# Running again loads changed files
load_all("./")

# With export_all=FALSE, only objects listed as exports in NAMESPACE
# are exported
load_all("./", export_all = FALSE)
}
}
\keyword{programming}
