\name{repair_S4_docu}
\alias{repair_S4_docu}
\alias{repair_S4_docu.character}
\title{Repair S4 documentation in Rd files}
\usage{
  repair_S4_docu(x, ...)

  \method{repair_S4_docu}{character} (x, ...,
    ignore = NULL)
}
\arguments{
  \item{x}{Character vector of names of input files, or
  names of \R package directories. The latter will be
  expanded as appropriate. \code{x} is passed to
  \code{\link{pkg_files}} with the \sQuote{installed}
  argument set to \code{FALSE}. See there for further
  details.}

  \item{...}{Optional arguments, currently passed as
  \code{args} arguments to \code{\link{run_ruby}}. See
  there for details. The sole exception is an \code{sargs}
  argument, which is a character vector of options passed
  to the Ruby script. See below.}

  \item{ignore}{\code{NULL} or character vector with names
  of \R code files to ignore. Passed to
  \code{\link{pkg_files}}, see there for details of how
  names are matched.}
}
\value{
  Currently the return value of the call to
  \code{\link{run_ruby}}.
}
\description{
  Repair S4 documentation in Rd files by adding
  \code{docType}, \code{usage}, and \code{alias} entries.
}
\details{
  This reparation process is currently implemented in a
  Ruby script that comes with the package. It is
  automatically found in the installation directory but
  fails if a suitable version of Ruby, i.e. \eqn{\ge
  1.9.0}, is unavailable. See \code{\link{run_ruby}} for
  further details.

  This function is intended for augmenting Rd documentation
  generated by \pkg{roxygen2}, as long as it does not fully
  support S4. In addition to the generation of missing
  documentation entries, \code{repair_S4_docu} can also
  recognise S4 methods generated within a loop provided a
  specific annotation is used. An example is given below.

  Another annotation can be used for redirecting the
  generated entries from one Rd file to another one. The
  file extension and the directory path would be added
  automatically. See the examples.
}
\examples{
## this is an example for the redirection of Rd file names:
#= dim length
## i.e., text that would be sent to 'dim.Rd' would now instead be written
## to 'length.Rd'

## here is an example for automatically generated S4 methods from the opm
## package:
\dontrun{
  lapply(c(
    #+
    wells,
    plate_type
    #-
  ), FUN = function(func_) {
    setMethod(func_, OPMS, function(object, ...) {
      func_(plates(object)[[1L]], ...)
    }, sealed = SEALED)
  })
}
## method names between '#+' and '#-' were collected and their usage
## generated from the subsequent setMethod() call invoking a 'func_'
## variable.

## See also the 'docu.R' script provided with the pkgutils package, option
## '--s4methods'.
}
\seealso{
  Other rd-functions: \code{\link{check_examples}},
    \code{\link{check_keywords}},
          \code{\link{repair_docu}},   }
\keyword{package}

