% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_mcsim.R
\name{solve_mcsim}
\alias{solve_mcsim}
\alias{generate_infile}
\title{Solve PK Model Through \pkg{GNU MCSim}}
\usage{
solve_mcsim(
  x,
  mName,
  infile.name = NULL,
  outfile.name = NULL,
  setpoint.name = NULL,
  params = NULL,
  vars = NULL,
  time = NULL,
  condition = NULL,
  generate.infile = T,
  tell = T,
  rtol = 1e-06,
  atol = 1e-06,
  monte_carlo = NULL,
  dist = NULL,
  q.arg = NULL
)

generate_infile(
  infile.name = NULL,
  outfile.name = NULL,
  params,
  vars,
  time,
  condition,
  rtol = 1e-06,
  atol = 1e-06,
  monte_carlo = NULL,
  dist = NULL,
  q.arg = NULL
)
}
\arguments{
\item{x}{a list of storing information in the defined sensitivity function.}

\item{mName}{a string giving the name of the model or C file (without extension).}

\item{infile.name}{a character to assign the name of input file.}

\item{outfile.name}{a character to assign the name of output file.}

\item{setpoint.name}{a character to assign the name of file for parameter matrix.}

\item{params}{a character to assign the testing parameters.}

\item{vars}{a character or a vector to assign the selected output(s).}

\item{time}{a numeric vector to define the given time point(s).}

\item{condition}{a character to set the specific parameter value in the input file.}

\item{generate.infile}{a logical value to automatically generate the input file.}

\item{tell}{a logical value to automatically combine the result y to decoupling simulation x.}

\item{rtol}{an argument passed to the integrator (default 1e-6).}

\item{atol}{an argument passed to the integrator (default 1e-6).}

\item{monte_carlo}{a numeric value to define the sample size in Monte Carlo simulation.}

\item{dist}{a vector of distribution names corresponding to \code{<distribution-name>} in \pkg{GNU MCSim}.}

\item{q.arg}{a list of shape parameters in the sampling distribution (\code{dist}).}
}
\value{
The output result is the 4-dimension array with
c(model evaluations, replications, time-points, output variables).
}
\description{
Solve the differential equations of time-dependent quantity/concentration in different tissues/compartments
through \pkg{GNU MCSim}.
}
\details{
This function allows users to use external data file that assigned in \code{setpoint.name} as parameter matrix.
If you want to use it, be sure to define \code{n} and \code{setpoint.name}.
}
\section{Functions}{
\itemize{
\item \code{solve_mcsim}: Numerical analysis for the PK model by \pkg{GNU MCSim}.

\item \code{generate_infile}: Generate the \pkg{GNU MCSim} input file.
}}

\examples{

\dontrun{
pbtk1cpt_model()
mName <- "pbtk1cpt"
compile_model(mName)

q <- "qunif"
q.arg <- list(list(min = 0.4, max = 1.1),
              list(min = 0.1, max = 0.4),
              list(min = 1.0, max = 3.0))

params <- c("vdist", "ke", "kgutabs")

set.seed(1234)
x <- rfast99(params = params, n = 200, q = q, q.arg = q.arg, rep = 20)

infile.name <- "example.in"
outfile.name <- "example.csv"
vars <- "Ccompartment"

t <- seq(from = 0.25, to = 12.25, by = 0.5)

y <- solve_mcsim(x, mName = mName, infile.name = infile.name,
                 setpoint.name = "setpoint.dat",
                 outfile.name = outfile.name, params = params, vars = vars, time = t,
                 condition = "Agutlument = 10")
pksim(y)
}

}
