# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generate risk-set indicators
#'
#' @param X the response matrix (As, Xs, Ds).
#' @param W the ordered observed event times.
#' @return risk-set indicators Y_i(w_k) of the form I(A_i <= w_k <= X_i).
#' @export
SgInd <- function(X, W) {
    .Call('plac_SgInd', PACKAGE = 'plac', X, W)
}

#' Generate truncation-pair indicators
#'
#' @param X the response matrix (As, Xs, Ds).
#' @param W the ordered observed event times.
#' @return the truncation-pair indicators of the form I(w_k <= A_i)
#' - I(w_k <= XA_j).
#' @export
PwInd <- function(X, W) {
    .Call('plac_PwInd', PACKAGE = 'plac', X, W)
}

#' Generate time-depependent covariate indicators
#'
#' @param zeta the change point (jump time) of Z_v(t).
#' @param W the ordered observed event times.
#' @return the time-depependent covariate of the form Z_v(t) = I(w_k > zeta).
#' @export
TvInd <- function(zeta, W) {
    .Call('plac_TvInd', PACKAGE = 'plac', zeta, W)
}

#' C++ Function for Solving the PLAC Estimator.
#' (with time-dependent convariates independent of A^*)
#'
#' @param Z matrix for all the covariates history.
#' @param ZFV_ matrix for all covariates at the each individual's
#' observed survival time.
#' @param X the response matrix (As, Xs, Ds).
#' @param W the ordered observed event times.
#' @param Ind1 risk-set indicators.
#' @param Ind2 truncation pair indicators.
#' @param Dn number of ties at each observed event time.
#' @param b initial values of the regression coefficients.
#' @param h initial values of the baseline hazard function.
#' @param K maximal iteration number, the default is \code{K = 100}.
#' @return list of model fitting results for both conditional approach and
#' the PLAC estimator.
#' @export
PLAC_TD <- function(Z, ZFV_, X, W, Ind1, Ind2, Dn, b, h, K = 100L) {
    .Call('plac_PLAC_TD', PACKAGE = 'plac', Z, ZFV_, X, W, Ind1, Ind2, Dn, b, h, K)
}

#' Generate time-depependent covariate indicators
#'
#' @param eta a random variable of the Z_v(t) value before the change point.
#' @param zeta the change point (jump time).
#' @param W the ordered observed event times.
#' @return the time-depependent covariate indicators of the form Z_v(t) =
#'   eta * I(w_k <= zeta).
#' @export
TvInd2 <- function(eta, zeta, W) {
    .Call('plac_TvInd2', PACKAGE = 'plac', eta, zeta, W)
}

#' C++ Function for Solving the PLAC Estimator.
#' (with time-dependent convariates depending on A^*)
#'
#' @param ZF matrix for all the time-invariant covariates.
#' @param ZFV_ matrix for all covariates at the each individual's
#' observed survival time.
#' @param Z matrix for all the covariates history.
#' @param X the response matrix (As, Xs, Ds).
#' @param W the ordered observed event times.
#' @param Ind1 risk-set indicators.
#' @param Ind2 truncation pair indicators.
#' @param Dn number of ties at each observed event time.
#' @param b initial values of the regression coefficients.
#' @param h initial values of the baseline hazard function.
#' @param K maximal iteration number, the default is \code{K = 100}.
#' @return list of model fitting results for both conditional approach and
#' the PLAC estimator.
#' @export
PLAC_TDR <- function(ZF, ZFV_, Z, X, W, Ind1, Ind2, Dn, b, h, K = 100L) {
    .Call('plac_PLAC_TDR', PACKAGE = 'plac', ZF, ZFV_, Z, X, W, Ind1, Ind2, Dn, b, h, K)
}

#' C++ Function for Solving the PLAC Estimator.
#' (with time-invariant convariates only)
#'
#' @param Z matrix for all the covariates history.
#' @param X the response matrix (As, Xs, Ds).
#' @param W the ordered observed event times.
#' @param Ind1 risk-set indicators.
#' @param Ind2 truncation pair indicators.
#' @param Dn number of ties at each observed event time.
#' @param b initial values of the regression coefficients.
#' @param h initial values of the baseline hazard function.
#' @param K maximal iteration number, the default is \code{K = 100}.
#' @return list of model fitting results for both conditional approach and
#' the PLAC estimator.
#' @export
PLAC_TI <- function(Z, X, W, Ind1, Ind2, Dn, b, h, K = 100L) {
    .Call('plac_PLAC_TI', PACKAGE = 'plac', Z, X, W, Ind1, Ind2, Dn, b, h, K)
}

