% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stacks.r
\name{tamm_stack}
\alias{tamm_stack}
\title{tamm_stack}
\usage{
tamm_stack(lambda0 = 630, n1 = 1.28, n2 = 1.72, d1 = lambda0/4/n1,
  d2 = lambda0/4/n2, N = 2 * pairs, pairs = 4, dx1 = 0, dx2 = 0,
  dm = 50, metal = "epsAu", position = c("after", "before"),
  incidence = c("left", "right"), nleft = 1.5, nright = 1, dleft = 200,
  dright = 200, ...)
}
\arguments{
\item{lambda0}{central wavelength of the stopband}

\item{n1}{real refractive index for odd layers}

\item{n2}{real refractive index for even layers}

\item{d1}{odd layer thickness in nm}

\item{d2}{even layer thickness in nm}

\item{N}{number of layers, overwrites pairs}

\item{pairs}{number of pairs}

\item{dx1}{variation of last odd layer thickness in nm}

\item{dx2}{variation of last even layer thickness in nm}

\item{dm}{thickness of metal layer}

\item{metal}{character name of dielectric function}

\item{position}{metal position relative to DBR}

\item{incidence}{direction of incidence}

\item{nleft}{refractive index of entering medium}

\item{nright}{refractive index of outer medium}

\item{dleft}{distance from the left side for visualisation}

\item{dright}{distance from the right side for visualisation}

\item{...}{ignored}
}
\value{
list of class 'stack'
}
\description{
DBR-metal stack structure
}
\details{
periodic structure of dielectric layers against metal film
}
\author{
baptiste Auguie
}
\seealso{
Other stack user_level: \code{\link{dbr_stack}};
  \code{\link{embed_stack}}; \code{\link{layer_stack}};
  \code{\link{tamm_stack_ir}};
  \code{\link{tamm_stack_porous}}
}

