% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDat.R
\name{checkDat}
\alias{checkDat}
\title{checkDat}
\usage{
checkDat(
  dat,
  inv = NULL,
  species = "Species",
  site = "Site",
  quad = "Quad",
  year = "Year",
  geometry = "geometry",
  reformatDat = FALSE,
  ...
)
}
\arguments{
\item{dat}{An sf data.frame of the same format as
\code{\link{grasslandData}}. It must have columns that contains a unique
identification for each research site (default name is "Site"), species name
(default name is "Species"), quadrat identifier (default name is "Quad"),
year of data collection (default name is "Year") and an s.f 'geometry' column
that contains a polygon or multipolygon data type for each
individual observation.}

\item{inv}{The name of each element of the list is a
quadrat name in 'dat', and the contents of that list element is a numeric
vector of all of the years in which that quadrat (or other unique spatial
area) was sampled. Make sure this is the years the quadrat was actually
sampled, not just the years that have data in the 'dat' argument! This
argument allows the function to differentiate between years when the quadrat
wasn't sampled and years when there just weren't any individuals of a species
present in that quadrat.}

\item{species}{An optional character string argument. Indicates
the name of the column in 'dat' that contains species name data. It is
unnecessary to include a value for this argument if the column name is
"Species" (default value is 'Species').}

\item{site}{An optional character string argument. Indicates
the name of the column in 'dat' that contains site name data. It is
unnecessary to include a value for this argument if the column name is
"Site" (default value is 'Site').}

\item{quad}{An optional character string argument. Indicates
the name of the column in 'dat' that contains quadrat name data. It is
unnecessary to include a value for this argument if the column name is
"Quad" (default is 'Quad').}

\item{year}{An optional character string argument. Indicates
the name of the column in 'dat' that contains data for year of sampling. It
is unnecessary to include a value for this argument if the column name is
"Year" (default is 'Year').}

\item{geometry}{An optional character string argument. Indicates
the name of the column in 'dat' that contains sf geometry data. It is
unnecessary to include a value for this argument if the column name is
"geometry" (default is 'geometry').}

\item{reformatDat}{A TRUE/FALSE argument. If 'FALSE', which is the default
value, then \code{\link[=checkDat]{checkDat()}} prints a message that says the 'dat' and 'inv'
datasets are ready for use in the \code{\link[=trackSpp]{trackSpp()}} function. This message
includes any column name arguments that must be included in the \code{\link[=trackSpp]{trackSpp()}}
function call for these datasets.
If 'TRUE', \code{\link[=checkDat]{checkDat()}} returns a list with three elements: a version of
'dat' that has been checked for errors and is ready to be input directly into
the  \code{\link{trackSpp}} or  \code{\link{assign}} functions, a version of
'inv' that is checked and ready for input into \code{\link[=trackSpp]{trackSpp()}} or \code{\link[=assign]{assign()}},
and a character vector called 'userColNames' that has all of the user-defined
column names that were used in the original version of 'dat'.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
If the 'reformatDat' argument is FALSE (the default), the return of
this function is a message that says the 'dat' and 'inv' datasets are ready
for use in the \code{\link[=trackSpp]{trackSpp()}} function. This message includes any column name
arguments that must be included in the \code{\link[=trackSpp]{trackSpp()}} function call for these
datasets.
If the 'reformatDat' argument is TRUE, then \code{\link[=checkDat]{checkDat()}} returns a list that
contains versions of 'dat' and 'inv' that are ready to go directly into the
\code{\link[=trackSpp]{trackSpp()}} or \code{\link[=assign]{assign()}} functions. The list has the following elements:

\item{dat}{An sf data.frame that has five columns called 'Species', 'Site',
'Quad', 'Year', and 'geometry'. Any additional columns that were present in
the version of 'dat' input into the \code{\link[=checkDat]{checkDat()}} function will also be
included in this version, although the column names will be appended with
"_USER".}
\item{inv}{A named list. The name of each element of the list is a quadrat
name in 'dat', and the contents of that list element is a numeric vector of
all of the years in which that quadrat (or other unique spatial area) was
sampled. For each list element, the vector of years is in sequential order
from oldest to most recent.}
\item{userColNames}{A named character vector. This vector contains the column
names provided by the user for all of the required data columns in the
original version of 'dat'. The name of each vector element indicates the type
of data that is contained in the column with the name in that vector element.
For example, if the 'dat' data.frame input into \code{\link[=checkDat]{checkDat()}} has the names
'Species','location' 'quadrat', 'Year', and 'geometry', then this list element
will be a character vector of these values with the names 'species', 'site',
'quad', 'year', and 'geometry'. }
}
\description{
A function that both checks and prepares a data.frame for use in
the \code{\link{trackSpp}} function.
}
\details{
This function is used internally in \code{\link{trackSpp}} and other
plantTracker functions to check the 'dat' and 'inv' arguments and ensure that
they are in the correct format with the correct column names. \code{\link[=checkDat]{checkDat()}}
can also be used independently to check that a data.frame is in the correct
format and contains the correct data to be used in the \code{\link[=trackSpp]{trackSpp()}} or other
plantTracker functions.
}
\examples{
checkDat(dat = grasslandData,
inv = grasslandInventory)

checkDat(dat = grasslandData,
inv = grasslandInventory,
reformatDat = TRUE)

}
