% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AciC4.R
\name{AciC4}
\alias{AciC4}
\title{C4 Photosynthesis}
\usage{
AciC4(Ci, PPFD = 1500, Tleaf = 25, VPMAX25 = 120, JMAX25 = 400,
  Vcmax = 60, Vpr = 80, alpha = 0, gbs = 0.003, O2 = 210, x = 0.4,
  THETA = 0.7, Q10 = 2.3, RD0 = 1, RTEMP = 25, TBELOW = 0,
  DAYRESP = 1, Q10F = 2, FRM = 0.5, ...)
}
\arguments{
\item{Ci}{Intercellular CO2 concentration (ppm)}

\item{PPFD}{Photosynthetic photon flux density (mu mol m-2 s-1)}

\item{Tleaf}{Leaf temperature (C)}

\item{VPMAX25}{The maximum rate of PEP carboxylation (mu mol m-2 s-1)}

\item{JMAX25}{Maximum electron transport rate (at 25C)}

\item{Vcmax}{Maximum rate of carboxylation (mu mol m-2 s-1) (at 25C)}

\item{Vpr}{PEP regeneration (mu mol m-2 s-1)}

\item{alpha}{Fraction of PSII activity in the bundle sheath (-)}

\item{gbs}{Bundle sheath conductance (mol m-2 s-1)}

\item{O2}{Mesophyll O2 concentration}

\item{x}{Partitioning factor for electron transport}

\item{THETA}{Shape parameter of the non-rectangular hyperbola}

\item{Q10}{T-dependence parameter for Michaelis-Menten coefficients.}

\item{RD0}{Respiration at base temperature (RTEMP) (mu mol m-2 s-1)}

\item{RTEMP}{Base leaf temperature for respiration (C)}

\item{TBELOW}{Below this T, respiration is zero.}

\item{DAYRESP}{Fraction respiration in the light vs. that measured in the dark}

\item{Q10F}{T-dependence parameter of respiration}

\item{FRM}{Fraction of day respiration that is mesophyll respiration (Rm)}

\item{\dots}{Further arguments (currently ignored).}
}
\description{
An implementation of the A-Ci curve for C4 plants, based on von Caemmerer et al. (2000)
}
\details{
Note that the temperature response parameters have been hardwired in this function, and are based on von Caemmerer (2000).

Note that it is not (yet) possible to fit this curve to observations of photosynthesis (see \code{\link{fitaci}} to fit the C3 model of photosynthesis).
}
\examples{
# Simulate a C4 A-Ci curve. 
aci <- AciC4(Ci=seq(5,600, length=101))
with(aci, plot(Ci, ALEAF, type='l', ylim=c(0,max(ALEAF))))
}
\references{
Caemmerer, S.V., 2000. Biochemical Models of Leaf Photosynthesis. Csiro Publishing.
}
\author{
Rhys Whitley
}
