% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_topt_VJ.R
\name{fit_topt_VJ}
\alias{fit_topt_VJ}
\title{Fitting the temperature responses of Vcmax and Jmax}
\usage{
fit_topt_VJ(
  data,
  varnames = list(Vcmax = "Vcmax", Jmax = "Jmax", Tleaf = "Tleaf"),
  title = NULL,
  limit_jmax = 1e+05,
  limit_vcmax = 1e+05,
  ...
)
}
\arguments{
\item{data}{Dataframe containing Vcmax (maximum rubisco carboxylation
capacity in umol m-2 s-1), Jmax (maximum photosynthetic electron transport
to CO2 fixation in umol m-2 s-1), and Tleaf (leaf temperature in Celsius)}

\item{varnames}{Variable names to account for different spellings of Vcmax,
Jmax, and Tleaf.}

\item{title}{Graph title, usually a group name}

\item{limit_jmax}{Upper limit to Jmax values for fitting. Defaults to
100,000 umol m-2 s-1 as this is the "nonsense output" from fitaci. Ensures
that these points are not fit.}

\item{limit_vcmax}{Upper limit to Vcmax values for fitting. Defaults to
100,000 umol m-2 s-1.}

\item{...}{Arguments to be passed on to minpack.lm::nlsLM(). See ?nlsLM for
details.}
}
\value{
fit_topt_VJ fits the Topt modified Arrhenius function to Vcmax and
Jmax data. Note that Hd may max out at 3000 kJ mol-1 for Jmax and 2000 kJ
mol-1 for Vcmax.
REFERENCE
Medlyn BE, Dreyer E, Ellsworth D, Forstreuter M, Harley PC,
Kirschbaum MUF, Le Roux X, Montpied P, Strassemeyer J, Walcroft A,
Wang K, Loutstau D. 2002. Temperature response of parameters of a
biochemically based model of photosynthesis. II. A review of
experimental data. Plant Cell Environ 25:1167-1179
}
\description{
Fitting the temperature responses of Vcmax and Jmax
}
\examples{
\donttest{
#Read in data
data <- read.csv(system.file("extdata", "example_1.csv",
package = "plantecowrap"), stringsAsFactors = FALSE)
#Fit ACi Curves then fit temperature responses
fits <- fitacis2(data = data,
                 varnames = list(ALEAF = "A",
                                 Tleaf = "Tleaf",
                                 Ci = "Ci",
                                 PPFD = "PPFD",
                                 Rd = "Rd",
                                 Press = "Press"),
                 group1 = "Treat",
                 fitTPU = FALSE,
                 fitmethod = "bilinear",
                 gm25 = 10000,
                 Egm = 0)
#Extract coefficients
outputs <- acisummary(data, group1 = "Treat", fits = fits)
#Fit temperature response
tresp <- fit_topt_VJ(outputs)
#View plot
tresp[[3]]
}
}
