# Modified version of the Cefic Indus chem fate model
# Modified to include rest of body compartment
# Modified to have all compartments as diffusion limited


library(deSolve)

genericModel <- function(t,state,parameters){
  with(
    as.list(c(state,parameters)), {
      # PARAMETER SCALING
      #TISSUE VOLUME CHECK
      VOLTOTALC <- VOLBLOODC + VOLADIPC + VOLBRAINC + VOLHEARTC + VOLKIDNEYC + VOLINTESTC + VOLLIVERC + VOLLUNGSC + VOLMUSCLEC + VOLSKINC + VOLMARROWC +VOLRESTC
      
      #BLOOD FLOW CHECK
      FRTOTALC <- FRADIPC + FRBONEC + FRBRAINC + FRHEARTC + FRKIDNEYC + FRLIVVENC +FRLIVARTC + FRLUNGC + FRMUSCLEC + FRSKINC + FRMARROWC +FRRESTC
      
      # SCALED PULMONARY VENTILATION RATE
      ALVVENT <- ALVVENTC * BODYWT   # L/HR; SCALED PULMONARY VENTILATION RATE
      
      # SCALED TISSUE VOLUMES (L)
      VOLBLOOD <- VOLBLOODC * BODYWT*(0.85/VOLTOTALC)    # L; BLOOD
      #VOLBLUNGART <- FRART * VOLBLOOD      # L; ARTERIAL BLOOD
      #VOLBLUNGVEN <- FRVEN * VOLBLOOD      # L; VENOUS BLOOD
      VOLADIP <- VOLADIPC * BODYWT*(0.85/VOLTOTALC)  # L; ADIPOSE TISSUE
      VOLBONE <- VOLBONEC * BODYWT*(0.85/VOLTOTALC)     # L; BONE TISSUE
      VOLBRAIN <- VOLBRAINC * BODYWT *(0.85/VOLTOTALC)   # L; BRAIN TISSUE
      VOLHEART <- VOLHEARTC * BODYWT *(0.85/VOLTOTALC)   # L; HEART TISSUE
      VOLKIDNEY <- VOLKIDNEYC * BODYWT *(0.85/VOLTOTALC)  # L; KIDNEY TISSUE
      VOLINTEST <- VOLINTESTC * BODYWT*(0.85/VOLTOTALC)   # L; INTESTINE TISSUE
      VOLLIVER <- VOLLIVERC * BODYWT  *(0.85/VOLTOTALC)  # L; LIVER TISSUE
      VOLLUNGS <- VOLLUNGSC * BODYWT *(0.85/VOLTOTALC)   # L; LUNG TISSUE
      VOLMUSCLE <- VOLMUSCLEC * BODYWT*(0.85/VOLTOTALC)   # L; MUSCLE TISSUE
      VOLSKIN <- VOLSKINC * BODYWT  *(0.85/VOLTOTALC)   # L; SKIN TISSUE
      VOLMARROW <- VOLMARROWC * BODYWT*(0.85/VOLTOTALC)   # L; MARROW TISSUE
      VOLREST <- VOLRESTC*BODYWR*(0.85/VOLTOTALC)
      
      # SCALED BLOOD FLOWS (L / HR)
      CARDOUTP <- CARDOUTPC * BODYWT        # L/HR; CARDIAC OUTPUT
      QADIP <- FRADIPC * CARDOUTP/FRTOTALC         # L/HR; ADIPOSE BLOOD FLOW
      QBONE <- FRBONEC * CARDOUTP/FRTOTALC         # L/HR; BONE BLOOD FLOW
      QBRAIN <- FRBRAINC * CARDOUTP/FRTOTALC        # L/HR; BRAIN BLOOD FLOW
      QHEART <- FRHEARTC * CARDOUTP/FRTOTALC        # L/HR; HEART BLOOD FLOW
      QKIDNEY <- FRKIDNEYC * CARDOUTP/FRTOTALC       # L/HR; KIDNEY BLOOD FLOW
      QLIVVEN <- FRLIVVENC * CARDOUTP/FRTOTALC       # L/HR; LIVER VENOUS BLOOD FLOW
      QLIVART <- FRLIVARTC * CARDOUTP/FRTOTALC       # L/HR; LIVER ARTERIAL BLOOD FLOW
      QLUNG <- FRLUNGC * CARDOUTP/FRTOTALC         # L/HR; LUNG BLOOD FLOW
      QMUSCLE <- FRMUSCLEC * CARDOUTP/FRTOTALC       # L/HR; MUSCLE BLOOD FLOW
      QSKIN <- FRSKINC * CARDOUTP/FRTOTALC         # L/HR; SKIN BLOOD FLOW
      QMARROW <- FRMARROWC * CARDOUTP/FRTOTALC       # L/HR; MARROW BLOOD FLOW
      QREST <- FRRESTC*CARDOUTP/FRTOTALC 
      # TIME CONVERSIONS
      HOURS<-T
      DAYS<- 0.0416666666666667*T
      MINUTES<- 60.0*T
      WEEKS<-0.142857142857143*DAYS
      YEARS<-0.000114077116130504*HOURS
      MONTHS<-0.0328542094455852*DAYS
      
      # Concentrations
      CMUSCLE<-AMUSCLE/VOLMUSCLE
      CVMUSCLE<-CMUSCLE/PMUSCLE
      CSKIN<-ASKIN/VOLSKIN
      CVSKIN <- CSKIN / PSKIN 
      CBONE<-ABONE/VOLBONE
      CVBONE<-CBONE/PBONE
      CMARROW<-AMARROW/VOLMARROW
      CVMARROW<-CMARROW/PMARROW
      CADIPOSE<-AADIPOSE/VOLADIP
      CVADIPOSE <-  CADIPOSE / PADIP   
      CSTOM<-ASTOM/VOLINTEST
      CVSTOM<-CSTOM/PSTOM
      CLIVER<-ALIVER/VOLLIVER
      CVLIVER <-  CLIVER / PLIVER 
      CMET<-AMET/VOLLIVER
      CHEART<-AHEART/VOLHEART
      CVHEART <- CHEART / PHEART 
      CLUNG<-ALUNG/VOLLUNGS
      CVLUNG <- CLUNG / PLUNG  
      CINH<-0#*CEXP/(MW*RESPPROT)
      
      CKIDNEY<-AKIDNEY/VOLKIDNEY
      CVKIDNEY<-CKIDNEY/PKIDNEY
      CEXC<-AEXC/URINVOL
      CBRAIN<-ABRAIN/VOLBRAIN
      CVBRAIN<-CBRAIN/PBRAIN
      CVEN<-AVEN/VOLBLUNGVEN
      CART<- AART/VOLBLUNGART
      CALV<-CART/RCBA
      #MASSINITABS<-2*DENS*KPW0/FPART - 2*DENS*KPW0*STRATCORN/(FPART*MASSLOAD)
      #RTSCMC<-2*STRATCORN/MAXCAP
      #SKINFLUX<-1000.0*RAMTABS*SKINAREA/MW
      
      #Oral Exposure
      RTOTDOSE <- 0
      avlbl_dose<- DecrBolusRt * DOSE
      RODOSE <- -avlbl_dose
      # Amounts
      # muscle
      RAMUSCLE<-CART*QMUSCLE - CVMUSCLE*QMUSCLE
      #skin
      RASKIN<-CART*QSKIN - CVSKIN*QSKIN
      # bone
      RABONE<-CART*QBONE - CVBONE*QBONE
      #Marrow
      RAMARROW<-CART*QMARROW - CVMARROW*QMARROW
      # fat
      RAADIPOSE<-CART*QADIP - CVADIPOSE*QADIP
      # Gastric
      RASTOM<-avlbl_dose + CART*QLIVVEN - CVSTOM*QLIVVEN
      # Liver Metab
      RAMET<-CVLIVER*VMAX/(CVLIVER + KM)
      #LIVER
      RALIVER<-CART*QLIVART - CVLIVER*QLIVART - CVLIVER*QLIVVEN + CVSTOM*QLIVVEN - RAMET
      # Heart
      RAHEART<-CART*QHEART - CVHEART*QHEART
      # Lung
      RALUNG<-CART*QLUNG - CVLUNG*QLUNG
      # Exhaled from Lung
      RAEXH<-ALVVENT*CALV
      # Inhaled into Lung
      RAINH<-ALVVENT*CINH
      # Kidney Exceretion
      RAEXC<-CVKIDNEY*FRWSOL*GLOMFILTR*QKIDNEY*REMOVKDN
      # Kidney
      RAKIDNEY<-CART*QKIDNEY - CVKIDNEY*QKIDNEY - RAEXC
      
      # Urine Generation
      RURINVOL<-0.0416666666666667*BODYWT*URINFLOW
      #Brain
      RABRAIN<-CART*QBRAIN - CVBRAIN*QBRAIN
      # Arterial Blood
      RAART<--ALVVENT*CALV + ALVVENT*CINH - CART*CARDOUTP + CVEN*CARDOUTP
      # venous Blood
      RAVEN<-CVADIPOSE*QADIP + CVBONE*QBONE + CVBRAIN*QBRAIN + CVHEART*QHEART + CVKIDNEY*QKIDNEY + CVLIVER*QLIVART + CVLIVER*QLIVVEN + CVLUNG*QLUNG + CVMARROW*QMARROW + CVMUSCLE*QMUSCLE + CVSKIN*QSKIN - CVEN*CARDOUTP
      
      # Area Under Curves
      RAUCMUSCLE <- CMUSCLE
      RAUCBRAIN <- CBRAIN
      RAUCLIVER <- CLIVER
      RAUCBONE <- CBONE
      RAUCLUNG <- CLUNG
      RAUCSKIN <- CSKIN
      RAUCMARROW <- CMARROW
      RAUCVEN  <- CVEN
      RAUCADIPOSE <- CADIPOSE
      RAUCKIDNEY <- CKIDNEY
      RAUCSTOM <- CSTOM
      RAUCART <- CART
      RAUCHEART <- CHEART
      
      # MAss Balance
      TOTBOD<-AADIPOSE + AART + ABONE + ABRAIN + AHEART + AKIDNEY + ALIVER + ALUNG + AMARROW + AMUSCLE + DOSE + ASKIN + ASTOM + AVEN
      TOTCLEAR<-AEXC + AEXH + AMET
      TMASS<- TOTDOSE-TOTBOD - TOTCLEAR
      
      list(c(RAMUSCLE,RAEXH,RABRAIN,RAEXC,RALIVER,RABONE,RALUNG,RASKIN,RAMARROW,RAINH,RAVEN,RURINVOL,RAADIPOSE,RAKIDNEY,RASTOM,RAMET,RTOTDOSE,RODOSE,RAART,RAHEART,
             RAUCMUSCLE,RAUCBRAIN,RAUCLIVER,RAUCBONE,RAUCLUNG,RAUCSKIN,RAUCMARROW,RAUCVEN,RAUCADIPOSE,RAUCKIDNEY,RAUCSTOM,RAUCART,RAUCHEART),
           "cmusc"=CMUSCLE,"cbrn"=CBRAIN,"cliv"=CLIVER,"cbne"=CBONE,"clng"=CLUNG,"cskn"=CSKIN,"cmarr"=CMARROW,"cven"=CVEN,"cadip"=CADIPOSE,"ckdn"=CKIDNEY,
           "cstm"=CSTOM,"cart"=CART,"chrt"=CHEART,"bal"=TMASS
           )
    })
}