\name{draw.GP}
\alias{draw.GP}
\alias{draw.CGP}
\alias{draw.ConstGP}

\title{
  Metropolis-Hastings draw for GP parameters
}
\description{
  Functions for using Metropolis-Hastings (MH) to evolve a particle
  according to the posterior distribution given by a
  Gaussian process (GP) for regression, classification,
  or combined unknown constraint model
}
\usage{
draw.GP(Zt, prior, l = 3, h = 4, thin = 10, Y = NULL)
draw.CGP(Zt, prior, l = 3, h = 4, thin = 10)
draw.ConstGP(Zt, prior, l = 3, h = 4, thin = 10)
}
\arguments{
  \item{Zt}{
    the particle describing model parameters and sufficient statistics
    that determines the predictive distribution
  }
  \item{prior}{
    prior parameters passed from \code{\link{PL}} generated by one of
    the prior functions, e.g., \code{\link{prior.GP}}
  }
  \item{l}{
    positive uniform random walk parameter; for old parameter
    \code{pold}, a new parameter is proposed as
    \code{p = runif(1, p*l/h, p*h/l)}.  Such proposals are then
    accepted (or rejected) via the MH acceptance ratio
  }
  \item{h}{
    positive uniform random walk parameter; see above
  }
  \item{thin}{
    thinning level in the MCMC; describes the number of MH rounds
    executed before the value is saved as a sample from the
    (marginal) posterior distribution
  }
  \item{Y}{
    not for external use; used internally by CGP and ConstGP internal
    routines
  }
}
\details{
  These functions are used in two important places in \pkg{plgp}.
  At the user level, they can be used to initialize the particles
  at time \code{start}; see \code{\link{PL}} and the demos.
  Internally, they are used in the \code{\link{PL}} propagate
  step, e.g.,  \code{\link{propagate.GP}}

  \code{draw.ConstGP} is a combination
  of the \code{draw.GP} and \code{draw.CGP} methods, which are
  for regression and classification GPs, respectively
}
\value{
  These functions return an updated particle \code{Zt}
}
\references{

 Gramacy, R. and Polson, N. (2011).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Journal of Computational and Graphical Statistics, 20(1), 
  pp. 102-118; arXiv:0909.5262

  Gramacy, R. and Lee, H. (2010).
  \dQuote{Optimization under unknown constraints}.
  \emph{Bayesian Statistics 9}, J. M. Bernardo, M. J. Bayarri,
  J. O. Berger, A. P. Dawid, D. Heckerman, A. F. M. Smith and M. West
  (Eds.); Oxford University Press

  Gramacy, R. (2020).
  \dQuote{Surrogates: Gaussian Process Modeling, Design and Optimization for the Applied Sciences}.
  Chapman Hall/CRC; \url{https://bobby.gramacy.com/surrogates/}

  \url{https://bobby.gramacy.com/r_packages/plgp/}
}
\author{
Robert B. Gramacy, \email{rbg@vt.edu}
}
\seealso{
  \code{\link{init.GP}}, \code{\link{propagate.GP}},
  \code{\link{PL}}
}
\examples{
## See the demos via demo(package="plgp") and the examples
## section of ?plgp
}
\keyword{ models }
\keyword{ regression }
\keyword{ classif }
\keyword{ methods }
