% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_contour_line}
\alias{image_contour_line}
\title{Smooth Contour Line Detection}
\usage{
image_contour_line(img, index = "GRAY", Q = 2)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{index}{A character string with the index to be used. Defaults to \code{"GRAY"}.}

\item{Q}{numeric value with the pixel quantization step}
}
\value{
A list with the contour lines.
}
\description{
Smooth Contour Line Detection
}
\examples{
if(interactive()){
library(pliman)
img <- image_pliman("sev_leaf.jpg")
conts <- image_contour_line(img, index = "B")
plot(img)
plot_contour(conts, col = "black")
}

}
