% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_data.R
\name{create_plot_data}
\alias{create_plot_data}
\title{Create Plot Data}
\usage{
create_plot_data(data, id, plotlevel, show_missing = FALSE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing an ID-variable specifying either a municipality, region, province or zipcode (see \code{id}), as well as a value-variable
containing any value to be plotted on the chosen level.}

\item{id}{A \code{character} specifying the name of a column in data containing the ID on the chosen level.

For municipalities these variables can be either;
\itemize{
\item A character-variable with danish municipality names. For accepted values see \link[plotDK]{municipality_info}.
\item A numeric/integer-variable with official municipality numbers. For accepted values see \link[plotDK]{municipality_info}.
}

For regions these variables can either;
\itemize{
\item A character-variable with danish region names. For accepted values see \link[plotDK]{region_info}.
\item A numeric/integer-variable with danish region numbers. For accepted values see \link[plotDK]{region_info}.
}

For provinces these variables can be either;
\itemize{
\item A character-variable with danish province names. For accepted values see \link[plotDK]{province_info}.
\item A numeric/integer-variable with danish province numbers. For accepted values see \link[plotDK]{province_info}.
}

For zip-codes these variables can be;
\itemize{
\item A numeric/integer-variable with danish zip-codes. For accepted values see \link[plotDK]{zipcode_info}.
}}

\item{plotlevel}{\code{character}, indicating which level to plot. Valid options are "municipality", "region", "province", and "zipcode".}

\item{show_missing}{\code{logical}. Should levels not present in data or with NA-values be printed? This can be used to plot only a subset
of entities.}

\item{...}{Further arguments to pass to merge_data}
}
\value{
A \code{data.frame} with either raw geom-data or geom-data merged with any data provided.
}
\description{
If data is provided, this functions attempts to merge the provided data with the geom-data 
inherent in the package on the chosen plotlevel. If no data is provided, only the geom-data for 
the chosen plotlevel is returned. This data is used to create the DK-plot.
}
