% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ggroc.R
\name{ggroc}
\alias{ggroc}
\title{Plot an ROC curve}
\usage{
ggroc(rocdata, fpf_string = "FPF", tpf_string = "TPF", ci = FALSE,
  label = NULL, label.adj.x = 0, label.adj.y = 0, label.angle = 45)
}
\arguments{
\item{rocdata}{Data frame containing true and false positive fractions, and
cutoff values}

\item{fpf_string}{Column name identifying false positive fraction column}

\item{tpf_string}{Column name identifying true positive fraction column}

\item{ci}{Logical, if TRUE will create invisible confidence regions for use
in the interactive plot}

\item{label}{Optional direct label for the ROC curve}

\item{label.adj.x}{Adjustment for the horizontal positioning of the label}

\item{label.adj.y}{Adjustment for the vertical positioning of the label}

\item{label.angle}{Adjustment for angle of label}
}
\value{
A ggplot object
}
\description{
Given a data frame or list of data frames as computed by \link{calculate_roc}
plot the curve using ggplot and sensible defaults. Pass the resulting object
and data to \link{export_interactive_roc}, \link{plot_interactive_roc}, or
\link{plot_journal_roc}.
}

