% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_transparent_text.R
\name{annotation_transparent_text}
\alias{annotation_transparent_text}
\title{Layer for Transparent Text}
\usage{
annotation_transparent_text(label, xmin, xmax, ymin, ymax, bg = "black",
  alpha = 0.5, interpolate = TRUE, result_interpolate = TRUE,
  expand = c(0.08, 0.08), family = "SimHei", fontface = 1,
  reflow = FALSE, place = "center", bg_trim = NULL,
  result = c("layer", "magick"), width = 800, height = NULL,
  res = 72)
}
\arguments{
\item{label}{the text.}

\item{xmin}{the left side of the rectangle.}

\item{xmax}{the right side of the rectangle.}

\item{ymin}{the bottom side of the rectangle.}

\item{ymax}{the top side of the rectangle.}

\item{bg}{the colors of the rectangle. It can be 
a character vector of colors, a matrix of colors, 
an object of raster class or even a image 
read into R through \code{magick::image_read}.
Default is color black.}

\item{alpha}{it is only used 
when \code{bg} is a character 
vector. Default is 0.5.}

\item{interpolate}{when \code{bg} is 
a matrix, a image or 
a raster, this parameter is used and 
will be passed to \code{ggplot2::annotation_raster} 
to draw a colored rectangle. Default is TRUE.}

\item{result_interpolate}{whether to use interpolate 
in the final result. Default is TRUE.}

\item{expand}{sometimes 
it is needed to slightly expand the x position and 
y position to put the text so that they can be 
shown. It should be two values used by x and y
respectively. Default is 0.08 and 0.08.}

\item{family}{family of text. Default is SimHei 
which ensures that Chinese texts can be shown.}

\item{fontface}{fontface.}

\item{reflow}{whether to change lines 
automatically. It will be passed to 
\code{ggfittext::geom_fit_text}. Default is FALSE.}

\item{place}{position adjustment used by 
\code{ggfittext:;geom_fit_text}.}

\item{bg_trim}{whether to trim \code{bg}. Most 
of the time we do want to trim it. However, the 
\code{magick::image_trim} function sometimes 
trims wrongly. So you can turn it off. NOTE: the default 
value of \code{bg_trim} is NULL, which means 
DO NOT TRIM.}

\item{result}{when it is "layer", the function can be 
used as a ggplot layer. When it is "magick", the result 
is only an image which is created by the magick package.}

\item{width}{the width of 
the text rectange. It will be passed 
to \code{magick::image_graph}. Most of the time you do 
not need to modify this. Default is 800.}

\item{height}{the height of the 
text rectange. It will be passed 
to \code{magick::image_graph}. Most of the time you do 
not need to modify this. Default is NULL, which means 
it will be computed automatically.}

\item{res}{resolution in pixels which will be passed 
to \code{magick::image_graph}. Default is 72.}
}
\description{
Suppose there is a colored rectangle
with some texts and 
you want the texts to be transparent so that 
the colors of the background can be seen. Now 
you can use this function. The function 
can be used as a ggplot layer or a generator 
of image. NOTE: when the function is 
used as a layer, it uses 
\code{ggplot2::annotation_raster} to 
do the drawing, so you must 
set limits for the x axis and the y axis. See examples.
}
\examples{
\donttest{
# Example 1
m=matrix(rainbow(7), nrow=1)
ggplot()+coord_fixed()+
	xlim(0, 7)+ylim(-2, 4)+theme_void()+
	annotation_raster(
		raster=m, 
		xmin=0, ymin=-3, 
		xmax=7, ymax=5, 
		interpolate=TRUE
	)+
	annotation_transparent_text(
		label="R\\nDATA\\nVISUALIZATION", 
		xmin=0, xmax=7, 
		ymin=-1, ymax=3, 
		family="sans", fontface=2, alpha=0.8, 
		place="left", expand=c(0.08, 0.02)
	)
# 
# Example 2, this time the result is only an image.
tt=annotation_transparent_text(
	label="abcdefg", 
	xmin=1, xmax=8, 
	ymin=1, ymax=4, 
	alpha=0.6, 
	result="magick"
)
#
# Example 3, the rectangle is a matrix.
m=colorRampPalette(c("yellow", "purple"))(10)
ggplot()+coord_fixed(expand=FALSE)+
	theme(panel.background=element_rect(fill="red"))+
	xlim(0, 9)+
	ylim(0, 5)+
	annotation_transparent_text(
		label="hehehaha", 
		xmin=1, xmax=8, 
		ymin=1, ymax=4, 
		bg=m, alpha=1
	)
}
}
