% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plot_ly}
\alias{plot_ly}
\title{Initiate a plotly visualization}
\usage{
plot_ly(data = data.frame(), ..., type = "scatter", group, color, colors,
  symbol, symbols, size, width = NULL, height = NULL, inherit = TRUE,
  evaluate = FALSE)
}
\arguments{
\item{data}{A data frame (optional).}

\item{...}{These arguments are documented at \url{https://plot.ly/r/reference/}
Note that acceptable arguments depend on the value of \code{type}.}

\item{type}{A character string describing the type of trace.}

\item{group}{Either a variable name or a vector to use for grouping. If used, 
a different trace will be created for each unique value.}

\item{color}{Either a variable name or a vector to use for color mapping.}

\item{colors}{Either a colorbrewer2.org palette name (e.g. "YlOrRd" or "Blues"), 
or a vector of colors to interpolate in hexadecimal "#RRGGBB" format, 
or a color interpolation function like \code{colorRamp()}.}

\item{symbol}{Either a variable name or a (discrete) vector to use for symbol encoding.}

\item{symbols}{A character vector of symbol types. Possible values:
'dot', 'cross', 'diamond', 'square', 'triangle-down', 'triangle-left', 'triangle-right', 'triangle-up'}

\item{size}{A variable name or numeric vector to encode the size of markers.}

\item{width}{Width in pixels (optional, defaults to automatic sizing).}

\item{height}{Height in pixels (optional, defaults to automatic sizing).}

\item{inherit}{logical. Should future traces inherit properties from this initial trace?}

\item{evaluate}{logical. Evaluate arguments when this function is called?}
}
\description{
Transform data into a plotly visualization.
}
\details{
There are a number of "visual properties" that aren't included in the officical 
Reference section (see below).
}
\examples{
\dontrun{
data(economics, package = "ggplot2")
# basic time-series plot
p <- plot_ly(economics, x = date, y = uempmed, type = "scatter", 
  showlegend = FALSE)
# add a loess smoother
p2 <- add_trace(p, y = fitted(loess(uempmed ~ as.numeric(date))))
# add a title
p3 <- layout(p2, title = "Median duration of unemployment (in weeks)")
# change the font
layout(p3, font = list(family = "Courier New, monospace"))

# using the color argument
plot_ly(economics, x = date, y = unemploy / pop, color = pop, mode = "markers")
plot_ly(economics, x = date, y = unemploy / pop, color = pop, 
  colors = terrain.colors(5), mode = "markers")
  
# function to extract the decade of a given date
decade <- function(x) {
  factor(floor(as.numeric(format(x, "\%Y")) / 10) * 10)
}
plot_ly(economics, x = unemploy / pop, color = decade(date), type = "box")

# plotly loves pipelines
economics \%>\%
 transform(rate = unemploy / pop) \%>\%
 plot_ly(x = date, y = rate) \%>\%
 loess(rate ~ as.numeric(date), data = .) \%>\%
 broom::augment() \%>\%
 add_trace(y = .fitted)

# sometimes, a data frame isn't fit for the use case...
# for 3D surface plots, a numeric matrix is more natural
plot_ly(z = volcano, type = "surface")
}

}
\author{
Carson Sievert
}
\seealso{
\code{\link{layout}()}, \code{\link{add_trace}()}, \code{\link{style}()}
}

