% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvrV.R
\name{mvrV}
\alias{mvrV}
\title{Multivariate regression function}
\usage{
mvrV(formula, ncomp, Y.add, data, subset, na.action, shrink,
  method = c("truncation", "stpls", "model.frame"), scale = FALSE,
  validation = c("none", "CV", "LOO"), model = TRUE, x = FALSE,
  y = FALSE, ...)
}
\arguments{
\item{formula}{a model formula. Most of the lm formula constructs are supported. See below.}

\item{ncomp}{the number of components to include in the model (see below).}

\item{Y.add}{a vector or matrix of additional responses containing relevant information about the observations. Only used for cppls.}

\item{data}{an optional data frame with the data to fit the model from.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain missing values. The default is set by the na.action setting of options, and is na.fail if that is unset. The 'factory-fresh' default is na.omit. Another possible value is NULL, no action. Value na.exclude can be useful. See na.omit for other alternatives.}

\item{shrink}{optional shrinkage parameter for \code{stpls}.}

\item{method}{the multivariate regression method to be used. If "model.frame", the model frame is returned.}

\item{scale}{numeric vector, or logical. If numeric vector, X is scaled by dividing each variable with the corresponding element of scale. If scale is TRUE, X is scaled by dividing each variable by its sample standard deviation. If cross-validation is selected, scaling by the standard deviation is done for every segment.}

\item{validation}{character. What kind of (internal) validation to use. See below.}

\item{model}{a logical. If TRUE, the model frame is returned.}

\item{x}{a logical. If TRUE, the model matrix is returned.}

\item{y}{a logical. If TRUE, the response is returned.}

\item{...}{additional arguments, passed to the underlying fit functions, and mvrCv.}
}
\description{
Adaptation of \code{mvr} from package \code{pls} v 2.4.3.
}
\seealso{
\code{\link[pls]{mvr}}
}
