% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{multi_predict._mixo_pls}
\alias{multi_predict._mixo_pls}
\alias{multi_predict._mixo_spls}
\alias{multi_predict._mixo_plsda}
\alias{multi_predict._mixo_splsda}
\title{Model predictions across many sub-models}
\usage{
\method{multi_predict}{`_mixo_pls`}(object, new_data, num_comp = NULL, type = NULL, ...)

\method{multi_predict}{`_mixo_spls`}(object, new_data, num_comp = NULL, type = NULL, ...)

\method{multi_predict}{`_mixo_plsda`}(object, new_data, num_comp = NULL, type = NULL, ...)

\method{multi_predict}{`_mixo_splsda`}(object, new_data, num_comp = NULL, type = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{model_fit}}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{num_comp}{An integer vector for the number of PLS terms to retain.}

\item{type}{A single character value or \code{NULL}. Possible values
are "numeric", "class", or "prob". When \code{NULL}, \code{predict()} will choose an
appropriate value based on the model's mode.}

\item{...}{Not currently used.}
}
\description{
Model predictions across many sub-models
}
\examples{
data(meats, package = "modeldata")

mv_meats <-
  pls(num_comp = 20, num_terms = 10) \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("regression") \%>\%
  fit_xy(x = meats[-(1:5), 1:100], y = meats[-(1:5), 101:103])

pred_vals <- multi_predict(mv_meats, meats[1:5, 1:100], num_comp = 1:10)
# Predictions over components nested within sample rows
pred_vals

# For first sample:
pred_vals$.pred[[1]]

}
