% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_eventlog.R
\name{generate_eventlog}
\alias{generate_eventlog}
\title{Generate random event log}
\usage{
generate_eventlog(
     size_of_eventlog = 1000, 
     number_of_cases = 20, 
     categories = c("normal", "visit", "phone", "target"),
     categories_size = c(5, 4, 3, 2))
}
\arguments{
\item{size_of_eventlog}{The size of generated event log}

\item{number_of_cases}{How many cases in the simulation}

\item{categories}{A data frame contains the activity category}

\item{categories_size}{How many activity categories in each activity category}
}
\description{
This function provides the ability to randomly generate the \code{eventlog} data frame based on given parameters.
}
\examples{
eventlog <- generate_eventlog(
     size_of_eventlog = 10000,
     number_of_cases = 2000,
     categories = c("campaign", "sale"),
     categories_size = c(10, 4)
     )

str(eventlog)
# 'data.frame':	10000 obs. of  4 variables:
#  $ timestamp  : POSIXct, format: "2017-01-01 02:16:16" ...
#  $ case_id: chr  "Case 107" "Case 1828" "Case 587" "Case 1666" ...
#  $ activity : chr  "Activity 4 (campaign)" "Activity 11 (sale)" "Activity 7 (campaign)" ...
#  $ category : chr  "campaign" "sale" "campaign" "sale" ...
head(eventlog)
#             timestamp   case_id         activity category
# 1 2017-01-01 02:16:16  Case 107 Activity 4 (campaign)   campaign
# 2 2017-01-01 03:04:22 Case 1828    Activity 11 (sale)       sale
# 3 2017-01-01 03:36:35  Case 587 Activity 7 (campaign)   campaign
# 4 2017-01-01 05:00:11 Case 1666    Activity 14 (sale)       sale
# 5 2017-01-01 05:38:24 Case 1287    Activity 11 (sale)       sale
# 6 2017-01-01 05:48:22 Case 1286 Activity 7 (campaign)   campaign
}
