% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_loess.R
\name{normalize_loess}
\alias{normalize_loess}
\title{Loess Normalization}
\usage{
normalize_loess(omicsData, method = "fast", span = 0.4)
}
\arguments{
\item{omicsData}{an object of the class 'pepData', 'proData', 'metabData',
'lipidData', or 'nmrData', created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, or \code{\link{as.nmrData}}, respectively. The
function \code{\link{group_designation}} must have been run on omicsData to
use several of the subset functions (i.e. rip and ppp_rip).}

\item{method}{character string specifying which variant of the cyclic loess
method to use. Options are "fast" (default), "affy", or "pairs"}

\item{span}{span of loess smoothing window, between 0 and 1.}
}
\value{
The normalized data is returned in an object of the appropriate S3
class (e.g. pepData), on the same scale as omicsData (e.g. if omicsData
contains log2 transformed data, the normalization will be performed on the
non-log2 scale and then re-scaled after normalization to be returned on the
log2 scale).
}
\description{
Perform Loess normalization
}
\details{
A wrapper for the normalizeCyclicLoess function from the limma
package.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mypep <- edata_transform(pep_object, "log2")
result <- normalize_loess(mypep)
\dontshow{\}) # examplesIf}
}
\references{
Bolstad, B. M., Irizarry R. A., Astrand, M., and Speed, T. P.
(2003). \emph{A comparison of normalization methods for high density
oligonucleotide array data based on bias and variance.} Bioinformatics 19,
185-193.

Ballman, KV Grill, DE, Oberg, AL and Therneau, TM (2004).
\emph{Faster cyclic loess: normalizing RNA arrays via linear models.}
Bioinformatics 20, 2778-2786.
}
\seealso{
\code{\link[limma]{normalizeCyclicLoess}} in the \code{limma} package
}
