% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.dimRes}
\alias{plot.dimRes}
\title{Plot dimRes Object}
\usage{
\method{plot}{dimRes}(
  x,
  omicsData = NULL,
  color_by = NULL,
  shape_by = NULL,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = 0,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  point_size = 4,
  bw_theme = TRUE,
  palette = NULL,
  ...
)
}
\arguments{
\item{x}{object of class dimRes created by the \code{dim_reduction}
function}

\item{omicsData}{optional omicsData for use in specifying a column name in
fdata when using \code{color_by} or \code{shape_by}.}

\item{color_by}{character string specifying which column to use to control 
the color for plotting. NULL indicates the default value of the main effect 
levels (if present). "Group" uses the "Group" column of group_DF. NA 
indicates no column will be used, and will use the default theme color. If 
an omicsData object is passed, any other value will use the specified 
column of f_data.}

\item{shape_by}{character string specifying which column to use to control 
the shape for plotting. NULL indicates the default value of the second main
effect levels (if present). "Group" uses the "Group" column of group_DF. NA 
indicates no column will be used, and will use the default theme shape. If 
an omicsData object is passed, any other value will use the specified 
column of f_data.}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label}

\item{y_lab}{character string specifying the y-axis label. The default is
NULL in which case the y-axis label will be the metric selected for the
\code{metric} argument.}

\item{x_lab_size}{integer value indicating the font size for the x-axis.
The default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis.
The default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.
The default is 0.}

\item{title_lab}{character string specifying the plot title}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{point_size}{An integer specifying the size of the points. The default
is 4.}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type 'dimRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

mylipid <- edata_transform(omicsData = lipid_neg_object, data_scale = "log2")
mylipid <- group_designation(omicsData = mylipid, main_effects = "Virus")
pca_lipids <- dim_reduction(omicsData = mylipid)
plot(pca_lipids)

\donttest{
myseq <- group_designation(omicsData = rnaseq_object, main_effects = "Virus")
pca_seq <- dim_reduction(omicsData = myseq)
plot(pca_seq)
}
\dontshow{\}) # examplesIf}
}
