% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmpp.R
\name{pmpp}
\alias{pmpp}
\title{Posterior Mean Panel Predictor for dynamic panel modelling}
\usage{
pmpp(dep_var, data, panel_ind = colnames(data[, 1:2]), exp_var = NULL,
  csi_var = NULL, post_mean_method = "gaussian",
  common_par_method = "QMLE", optim_method = "quadratic",
  dens_grid = 2^10, gmm_model = "twosteps", gmm_inst = 99,
  pure_data = FALSE)
}
\arguments{
\item{dep_var}{character string indicating name of dependent variable}

\item{data}{data.frame or matrix with input data}

\item{panel_ind}{vector of length 2 indicating names of variables indexing units and time periods respectively}

\item{exp_var}{vector of character strings indicating names of exogeneous explanatory variables}

\item{csi_var}{vector of character strings indicating names of cross-sectionally invariant explanatory variables; 
feature not supported yet}

\item{post_mean_method}{method for estimating the heterogeneous intercept parameters, one of "gaussian", "kernel"}

\item{common_par_method}{method for estimating the common parameters, one of "QMLE", "GMM_ABond", "GMM_BBond", 
GMM_ABover", "GMM_SSYS"}

\item{optim_method}{which optimisation routine to use, one of "gradient", "quadratic", "annealing"}

\item{dens_grid}{size of the grid over which data is interpolated for kernel density estimation; 
larger value may yield higher accuracy, but increases computation time}

\item{gmm_model}{number of steps for computing optimal GMM matrix, one of "onestep", "twosteps", 
"threesteps"; "threesteps" can be used for "GMM_SSYS" only}

\item{gmm_inst}{number of lagged values of the dependent variable to be used as GMM instruments 
in Arellano-Bond/Blundell-Bond setting}

\item{pure_data}{if TRUE, removes indexing/subsetting from model's call on data, facilitating use in a loop}
}
\value{
An object of class \code{pmpp}; a list with parameter estimates, fitted values,
        residuals, in-sample error measures and information on the data and function call.
}
\description{
This function estimates parameters of the Posterior Mean Panel
             Predictor (PMPP) model based on an empirical-Bayes approach to
             obtain unit-specific fixed effects.
}
\details{
The PMPP model is a two-step procedure. First, the homogeneous parameters are
         estimated using one of the QMLE or GMM-based methods:
         \itemize{
         \item Arellano-Bond estimator (Difference GMM),
         \item Arellano-Bover estimator (Level GMM),
         \item Blundell-Bond estimator (System GMM),
         \item Sub-optimal System GMM estimator,
         \item Quasi-Maximum Likelihood estimator.
         }
         Parameter \code{common_par_method} can be used to select the method for common parameters estimation.
         All the above methods only provide estimates of the homogeneous parameters, i.e. the
         ones measuring impact of lagged response and external variables. The intercept is removed in the
         estimation process.
         In the second step of the PMPP modelling, the individual-specific intercept is
         calculated based on the formula for posterior mean (Tweedie's Formula). It involves
         approximating certain density function, which can be done in two ways:
         \itemize{
         \item Parametrically, assuming Gaussian distribution,
         \item Using a 2D kernel density estimator.
         }
         Parameter \code{post_mean_method} can be used to select the method used for intercept estimation.
         For technical details on the methods, see the references.
}
\examples{
data(EmplUK, package = "plm")
EmplUK <- dplyr::filter(EmplUK, year \%in\% c(1978, 1979, 1980, 1981, 1982))
pmpp_model <- pmpp(dep_var = "emp", data = EmplUK)
}
\references{
Liu et al. (2016), "Forecasting with Dynamic Panel Data Models",
            PIER Working Paper No. 16022.,
            \url{https://papers.ssrn.com/sol3/Papers.cfm?abstract_id=2889000}

Oleszak, M. (2018). "Forecasting sales with micro-panels:
            Empirical Bayes approach. Evidence from consumer goods sector.",
            Erasmus University Thesis Repository
}
\author{
Michal Oleszak
}
