% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-select.R
\name{plotTE}
\alias{plotTE}
\title{Estimated total error plot}
\usage{
plotTE(
  hgrid,
  etotal,
  eround,
  hopt = NULL,
  elabels = NULL,
  echeck = NULL,
  epsilon = .Machine$double.eps^(7/8),
  ...
)
}
\arguments{
\item{hgrid}{Numeric vector: a sequence of step sizes used as the horizontal positions
(usually exponentially spaced).}

\item{etotal}{Numeric vector: estimated combined error at each step size.
This is typically computed by subtracting a more accurate finite-difference approximation from
a less accurate one.}

\item{eround}{Numeric vector: estimated rounding error at each step size; usually the best guess
or the upper bound is used.}

\item{hopt}{Numeric scalar (optional): selected optimal step size. If provided,
a vertical line is drawn at this value.}

\item{elabels}{Character vector of the same length as \code{hgrid} containing the following values:
\code{"r", "g", "o", "i", "b"} for \strong{r}ounding, \strong{g}ood truncation, \strong{o}kay truncation,
\strong{i}ncreasing truncation and \strong{b}ad truncation.}

\item{echeck}{Numeric vector: estimated V-shaped check, usually from a fit.}

\item{epsilon}{Numeric scalar: condition error, i.e. the error bound for the accuracy of the evaluated
function; used for labelling rounding error assumptions.}

\item{...}{Additional graphical parameters passed to \code{plot()}.}
}
\value{
Nothing (invisible null).
}
\description{
Visualises the estimated truncation error, rounding error, and total error
used in automatic step-size selection for numerical differentiation.
The plot follows the approach used in Mathur (2012) and other step-selection methods.
}
\examples{

a <- step.K(sin, 1)
hgrid <- a$iterations$h
etotal <- a$iterations$est.error[, 1]
eround <- a$iterations$est.error[, 2]
elabels <- c(rep("r", 32), rep("i", 2), rep("g", 12), rep("b", 15))
hopt <- a$par
plotTE(hgrid, etotal = 2e-12 * hgrid^2 + 1e-14 / hgrid,
       eround = 1e-14 / hgrid, hopt = 0.4, i.increasing = 30:45, i.good = 32:45,
       abline.round = c(-46.5, -1))
}
