% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerativeTemplate.R
\name{GenerativeTemplate}
\alias{GenerativeTemplate}
\title{R6 class representing a nested container for generator attributes}
\description{
\code{\link[R6:R6Class]{R6}} class representing a nested container for
\code{\link{Generator}} attributes that are maintained when new model clones are
created. The container maintains \emph{input} and \emph{output} attribute names,
file, function and distribution templates, correlation parameters (for distribution
generation), rounding decimals, occupancy mask, and any inherited class model
attributes that need to be maintained when cloning.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{description}}{A brief description of what the generator generates.}

\item{\code{inputs}}{An array of input attribute names for the generator.}

\item{\code{outputs}}{An array of output attribute names for the generator.}

\item{\code{file_templates}}{A list of file template attributes.}

\item{\code{function_templates}}{A list of function template attributes.}

\item{\code{distribution_templates}}{A list of distribution template attributes.}

\item{\code{uses_correlations}}{A boolean to indicate that a \code{\link{SpatialCorrelation}} (or inherited class) object is used for generating correlated random deviates.}

\item{\code{spatial_correlation}}{A \code{\link{SpatialCorrelation}} (or inherited class) object for generating correlated random deviates.}

\item{\code{temporal_correlation}}{Absolute correlation coefficient between simulation time steps for all grid cells (0-1; default = 1).}

\item{\code{time_steps}}{Number of simulation time steps (default = 1).}

\item{\code{generate_rasters}}{Boolean to indicate if rasters should be generated (default: NULL).}

\item{\code{decimals}}{Number of decimal places applied to the generated values (default: NULL = no rounding).}

\item{\code{occupancy_mask}}{Optional binary mask array (matrix), data frame, or raster (stack) for generated (time-series) data.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GenerativeTemplate-new}{\code{GenerativeTemplate$new()}}
\item \href{#method-GenerativeTemplate-clone}{\code{GenerativeTemplate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenerativeTemplate-new"></a>}}
\if{latex}{\out{\hypertarget{method-GenerativeTemplate-new}{}}}
\subsection{Method \code{new()}}{
Initialization method initializes the generator templates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenerativeTemplate$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenerativeTemplate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GenerativeTemplate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenerativeTemplate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
