% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cervical_validation.R
\docType{data}
\name{cervical_validation}
\alias{cervical_validation}
\title{Cervical cancer valiation data}
\format{A data frame with 4 rows and 6 variables:
\describe{
 \item{\code{v}}{Number of correct death certificates in each country
   in the validation sample }
 \item{\code{m}}{Size of validation sample in each country}
 \item{\code{country}}{Factor variable of European countries}
 \item{\code{W.1}, \code{W.2}, \code{W.3}}{ Predictor variables for country effects
   using dummy coding (i.e. England, France, Italy)}
 }}
\source{
Kelson, M. and Farebrother, M. (1987). The Effect of Inaccuracies in
  Death Certification and Coding Practices in the European Economic Community
  (EEC) on International Cancer Mortality Statistics. \emph{International
  Journal of Epidemiology}, 16, \strong{3}, 411-414.

Whittemore, A. S. and Gong, G. (1991). Poisson regression with
  missclassified counts: Application to cervical cancer mortality rates.
  \emph{Applied Statistics}, \strong{40}, 81-93.
}
\usage{
data(cervical_validation)
}
\description{
Additionally to the main study sample (see \code{\link{cervical}}),
validation data are available that give information on how likely physicians
from different countries are to identify and correctly report a true cervical
cancer death. In that study, a sample of physicians in each country completed
a death certificate for one specific patient who had died of cervical cancer
and the number of correct death certificates in each country was recorded.
Validation data are therefore available on country level but provide no
information on the reporting probability specific for age.
}
\note{
Belgium is used as the reference category.
}
\seealso{
\code{\link{cervical}}, \code{\link{pogitBvs}}
}

