% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{snip_list}
\alias{snip_list}
\title{A \code{fn} for \code{info_snippet()}: get a list of column categories}
\usage{
snip_list(
  column,
  limit = 5,
  sorting = c("inorder", "infreq", "inseq"),
  reverse = FALSE,
  sep = ",",
  and_or = NULL,
  oxford = TRUE,
  as_code = TRUE,
  quot_str = NULL,
  na_rm = FALSE,
  lang = NULL
)
}
\arguments{
\item{column}{\emph{The target column}

\verb{scalar<character>} // \strong{required}

The name of the column that contains the target values.}

\item{limit}{\emph{Limit for list length}

\verb{scalar<integer>} // \emph{default:} \code{5}

A limit of items put into the generated list. The returned text will state
the remaining number of items beyond the \code{limit}.}

\item{sorting}{\emph{Type of sorting within list}

\verb{singl-kw:[inorder|infreq|inseq]} // \emph{default:} \code{"inorder"}

A keyword used to designate the type of sorting to use for the list. The
three options are \code{"inorder"} (the default), \code{"infreq"}, and \code{"inseq"}.
With \code{"inorder"}, distinct items are listed in the order in which they
first appear. Using \code{"infreq"} orders the items by the decreasing frequency
of each item. The \code{"inseq"} option applies an alphanumeric sorting to the
distinct list items.}

\item{reverse}{\emph{Reversal of list order}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

An option to reverse the ordering of list items. By default, this is
\code{FALSE} but using \code{TRUE} will reverse the items before applying the
\code{limit}.}

\item{sep}{\emph{Separator text for list}

\verb{scalar<character>} // \emph{default:} \code{","}

The separator to use between list items. By default, this is a comma.}

\item{and_or}{\emph{Use of 'and' or 'or' within list}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The type of conjunction to use between the final and penultimate list items
(should the item length be below the \code{limit} value). If \code{NULL} (the
default) is used, then the 'and' conjunction will be used. Alternatively,
the following keywords can be used: \code{"and"}, \code{"or"}, or an empty string
(for no conjunction at all).}

\item{oxford}{\emph{Usage of oxford comma}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Whether to use an Oxford comma under certain conditions.}

\item{as_code}{\emph{Treat items as code}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Should each list item appear in a 'code font' (i.e., as monospaced text)?
By default this is \code{TRUE}. Using \code{FALSE} keeps all list items in the same
font as the rest of the information report.}

\item{quot_str}{\emph{Set items in double quotes}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

An option for whether list items should be set in double quotes. If \code{NULL}
(the default), the quotation marks are mainly associated with list items
derived from \code{character} or \code{factor} values; numbers, dates, and logical
values won't have quotation marks. We can explicitly use quotations (or
not) with either \code{TRUE} or \code{FALSE} here.}

\item{na_rm}{\emph{Remove NA values from list}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

An option for whether NA values should be counted as an item in the list.}

\item{lang}{\emph{Reporting language}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The language to use for any joining words (from the \code{and_or} option) or
additional words in the generated list string. By default, \code{NULL} will use
whichever \code{lang} setting is available in the parent
\emph{informant} object (this is settable in the \code{\link[=create_informant]{create_informant()}} \code{lang}
argument). If specified here as an override, the language options are
English (\code{"en"}), French (\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}),
Spanish (\code{"es"}), Portuguese (\code{"pt"}), Turkish (\code{"tr"}), Chinese (\code{"zh"}),
Russian (\code{"ru"}), Polish (\code{"pl"}), Danish (\code{"da"}), Swedish (\code{"sv"}), and
Dutch (\code{"nl"}).}
}
\value{
A formula needed for \code{\link[=info_snippet]{info_snippet()}}'s \code{fn} argument.
}
\description{
The \code{snip_list()} function can be used as an \code{\link[=info_snippet]{info_snippet()}} function (i.e.,
provided to \code{fn}) to get a catalog list from a table column. You can limit
the of items in that list with the \code{limit} value.
}
\section{Examples}{


Generate an informant object, add a snippet with \code{\link[=info_snippet]{info_snippet()}} and
\code{snip_list()} (giving us a method to get a distinct list of column values for
column \code{f}). Define a location for the snippet result in \code{{ }} and then
\code{\link[=incorporate]{incorporate()}} the snippet into the info text. Note here that the order of
the \code{\link[=info_columns]{info_columns()}} and \code{\link[=info_snippet]{info_snippet()}} calls doesn't matter.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <- 
  create_informant(
    tbl = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\% 
  info_columns(
    columns = f,
    `Items` = "This column contains \{values_f\}."
  ) \%>\%
  info_snippet(
    snippet_name = "values_f",
    fn = snip_list(column = "f")
  ) \%>\%
  incorporate()
}\if{html}{\out{</div>}}

We can print the \code{informant} object to see the information report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_snip_list_1.png" alt="This image was generated from the first code example in the `snip_list()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

3-6
}

\seealso{
Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_columns_from_tbl}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()},
\code{\link{snip_highest}()},
\code{\link{snip_lowest}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
